set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7232191';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4214',
      '24203121',
      '40101214',
      '43333424',
      '00403323',
      '24334303',
      '30413131',
      '13003000',
      NULL,
      '10244414',
      '31242313',
      '42322444',
      '43101222',
      '42001140',
      '32302034',
      '21302141',
      '40002233',
      '21012331',
      NULL,
      NULL,
      '30222411',
      NULL,
      '30132401',
      '02420433',
      NULL,
      '30302203',
      '33443311',
      NULL,
      '43211343',
      NULL,
      NULL,
      '01240101',
      '01344243',
      '20443421',
      '14220234',
      '13033334',
      '32233420',
      NULL,
      '13222223',
      '12304014',
      '31443321',
      '23412010',
      NULL,
      NULL,
      '31302143',
      '',
      '',
      NULL,
      NULL,
      '3033004',
      0,
      NULL,
      NULL,
      NULL,
      '400340',
      0,
      ' 4-13-2002',
      NULL,
      95.356992,
      NULL,
      58,
      NULL,
      34.681217,
      13,
      71.369779,
      39,
      19,
      16.070469,
      11,
      22.305246,
      51.887386,
      13.703897,
      NULL,
      14,
      6,
      30,
      12.460636,
      22.115068,
      51,
      NULL,
      NULL,
      19.234573,
      NULL,
      27,
      44.112412,
      102,
      59,
      243,
      199,
      ' 7-12-1978',
      65,
      55.017506,
      42.626392,
      28.766484,
      122.407250,
      86,
      NULL,
      0,
      1,
      1.147026,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.956109,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-2000',
      NULL,
      NULL,
      3.208236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1992',
      NULL,
      118,
      107,
      62.282485,
      81.465338,
      29,
      18,
      34.673059,
      58,
      NULL,
      63.437957,
      73.578441,
      ' 8-13-1974',
      NULL,
      5,
      21,
      NULL,
      51,
      58.585790,
      8,
      ' 7- 4-1990',
      8.293251,
      14.610985,
      NULL,
      1.866619,
      8.577090,
      24.996066,
      1,
      21.792088,
      7.365483,
      NULL,
      NULL,
      NULL,
      38.041059,
      3.914119,
      NULL,
      12.003616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.992633,
      0.737446,
      NULL,
      ' 6- 5-1995',
      1,
      118.310918,
      ' 2-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 0-2002',
      52.806892,
      1.503559,
      8.376967,
      ' 2-17-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      60.643313,
      96.678104,
      0.952983,
      0,
      5.709171,
      1.186895,
      2.744357,
      10,
      NULL,
      1,
      NULL,
      0.062146,
      NULL,
      NULL,
      1.133809,
      NULL,
      84.080685,
      0,
      1,
      27,
      70,
      30.655663,
      6,
      0.918123,
      39,
      0,
      NULL,
      0,
      0,
      0.794007,
      0,
      1.569286,
      86,
      85.475611,
      3.961423,
      25,
      61,
      1.856954,
      1.238183,
      NULL,
      0.502055,
      0,
      1.868715,
      NULL,
      NULL,
      10,
      1.099958,
      NULL,
      NULL,
      0,
      98.891224,
      32.398898,
      0,
      13,
      67,
      101.988028,
      NULL,
      28.793620,
      2,
      0.672236,
      1.131057,
      NULL,
      NULL,
      0,
      1,
      0.488019,
      31,
      ' 3- 7-1983',
      '10- 1-1992',
      ' 8-21-1994',
      NULL,
      '10-22-1992',
      ' 5-25-1984',
      '10-29-1998',
      NULL);
commit;
end;
/


