set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7232191';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21420043',
      '42010323',
      '24101301',
      '22013241',
      '24142224',
      '34134312',
      '32033221',
      '44241242',
      '13434444',
      '01204313',
      '33403112',
      '04224443',
      '24401131',
      '40412011',
      '04412142',
      '13404403',
      NULL,
      '42244230',
      '40033200',
      '41032124',
      '20343113',
      '02320333',
      '42231002',
      NULL,
      '40221201',
      '12123303',
      '31044140',
      '30441412',
      NULL,
      '31043143',
      '11044210',
      '21413302',
      '34302411',
      '33013232',
      NULL,
      '44242330',
      '22332300',
      NULL,
      '24211422',
      '34300311',
      '42310123',
      '03341200',
      '24012331',
      NULL,
      '420',
      NULL,
      22,
      7.181580,
      '2310032',
      NULL,
      0.107181,
      NULL,
      NULL,
      '104043',
      1.587936,
      '11-12-1999',
      ' 5-23-1997',
      108,
      89.044932,
      17,
      NULL,
      2.459156,
      20,
      115,
      10,
      2,
      9,
      NULL,
      3.553358,
      51,
      23,
      30,
      19,
      33.504510,
      3.845545,
      17.630589,
      21,
      53.830034,
      16.649899,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      237,
      4,
      207.545991,
      ' 4-22-1979',
      34.406033,
      5.148585,
      20,
      34,
      165.492845,
      12,
      ' 4-19-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      5.414384,
      NULL,
      6,
      9.947455,
      ' 2-18-1981',
      NULL,
      NULL,
      35.094263,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      NULL,
      NULL,
      NULL,
      ' 0-10-1985',
      NULL,
      51.684813,
      66.778459,
      NULL,
      24.293668,
      51.626300,
      18.229555,
      51,
      NULL,
      77.114715,
      17.352050,
      26.771738,
      NULL,
      11.895043,
      2.601969,
      9,
      22.442632,
      44.173639,
      13.974537,
      8,
      ' 4- 6-1994',
      30.392152,
      7.809900,
      '11- 7-1975',
      NULL,
      3.262745,
      13.528862,
      24.207427,
      4,
      2.560829,
      1.772089,
      NULL,
      1.013375,
      86,
      1.267576,
      2.844855,
      NULL,
      16.316130,
      0,
      1.406277,
      NULL,
      1.896015,
      ' 2- 5-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      6.677851,
      2,
      ' 9- 6-1996',
      NULL,
      NULL,
      NULL,
      54,
      ' 3- 4-1998',
      32.532249,
      ' 0-27-2001',
      0,
      9,
      ' 9-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      13.272349,
      ' 9-23-1981',
      45,
      48,
      51,
      ' 1- 2-2003',
      1.288757,
      NULL,
      ' 5- 2-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


