set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7205942';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4222',
      '12311024',
      '42230103',
      '30342240',
      NULL,
      '00420110',
      '00411030',
      '13202223',
      NULL,
      '22441311',
      '04120130',
      '10233134',
      '44241301',
      '31322310',
      '40220404',
      '21434231',
      NULL,
      '11131122',
      NULL,
      '23431410',
      NULL,
      NULL,
      '30203040',
      '13233004',
      '03340122',
      NULL,
      '00322321',
      '00223232',
      '40002104',
      '01142041',
      '00431042',
      '24010411',
      '21421243',
      '40434430',
      '44332403',
      '32212430',
      '20103214',
      '10041203',
      '44130020',
      '12413002',
      '10031232',
      '22002124',
      '11423232',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1304223',
      0.274378,
      0,
      1,
      NULL,
      '232433',
      2,
      ' 6-12-1989',
      '10- 2-1993',
      45,
      NULL,
      15,
      12.831088,
      7.379354,
      17.586058,
      30.118705,
      18.579036,
      18,
      7.939257,
      42,
      16.115247,
      21.660132,
      NULL,
      23,
      NULL,
      NULL,
      4.021654,
      NULL,
      4,
      NULL,
      NULL,
      77,
      0.062893,
      1,
      30,
      NULL,
      NULL,
      119.262087,
      151.683169,
      NULL,
      ' 8-23-1974',
      56,
      16.181409,
      NULL,
      13.069859,
      21,
      235,
      '10-19-1999',
      1,
      1,
      1,
      NULL,
      4,
      NULL,
      2,
      3.075165,
      0.626343,
      0,
      1.839192,
      3,
      0,
      NULL,
      NULL,
      1.683451,
      5.278944,
      1,
      NULL,
      1.593195,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1974',
      NULL,
      52,
      4,
      5.574643,
      11.542334,
      3,
      ' 2-29-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      60.405112,
      107.678327,
      89,
      35,
      38.792158,
      75,
      NULL,
      NULL,
      60.969955,
      44.236032,
      ' 2-12-1990',
      6.281456,
      21.428099,
      10,
      43,
      68.321149,
      102,
      8.377574,
      NULL,
      12,
      NULL,
      ' 0-10-1990',
      12.196353,
      4,
      13,
      NULL,
      18,
      9.808919,
      0,
      19.332509,
      1.601406,
      92,
      1,
      1.973897,
      NULL,
      12,
      1.441138,
      3,
      NULL,
      NULL,
      ' 2-21-1987',
      0.752688,
      1,
      3.199070,
      NULL,
      NULL,
      15.592473,
      ' 7-11-1984',
      NULL,
      17.939221,
      '10- 2-1989',
      18,
      ' 2-22-1977',
      12,
      ' 8-11-1996',
      NULL,
      NULL,
      '11- 8-1993',
      13,
      3,
      ' 2-27-1981',
      NULL,
      NULL,
      ' 0-26-1988',
      2.679186,
      NULL,
      ' 5-20-1978',
      3,
      0,
      NULL,
      '11- 7-1989',
      NULL,
      NULL,
      6.471566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


