set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1133',
      NULL,
      '40120342',
      '34430100',
      '34410010',
      '42333443',
      '22141204',
      '24401322',
      '12341120',
      NULL,
      '03121212',
      '22330330',
      '04403204',
      '24414024',
      '34124214',
      '31014014',
      '43412341',
      '24233024',
      '14041010',
      '23341210',
      NULL,
      '31214422',
      NULL,
      NULL,
      '33341123',
      '01112320',
      '03422223',
      '24000044',
      '41024421',
      '04430332',
      '33333331',
      '30220423',
      '04314401',
      '03134314',
      '02340320',
      '12013003',
      NULL,
      NULL,
      '12342240',
      '12140202',
      '24103401',
      NULL,
      '31110332',
      '10212411',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '2203124',
      2.155900,
      0.021248,
      2,
      NULL,
      NULL,
      NULL,
      ' 0- 2-1995',
      NULL,
      103,
      NULL,
      44,
      11.744928,
      16.250099,
      12.604167,
      NULL,
      3,
      22,
      NULL,
      NULL,
      11.903412,
      37,
      8.550233,
      NULL,
      1.190500,
      4.496585,
      2.420996,
      7.212164,
      10.365426,
      37.393296,
      9,
      NULL,
      0,
      NULL,
      NULL,
      46,
      8,
      18,
      152.070970,
      109.754799,
      NULL,
      NULL,
      54,
      15,
      21.754133,
      96,
      201.908952,
      ' 9- 9-1981',
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457958,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-16-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-18-1994',
      13.422647,
      28,
      45,
      34,
      5,
      NULL,
      78,
      66.857047,
      NULL,
      19.716360,
      72.383434,
      21.364602,
      NULL,
      NULL,
      5,
      20,
      NULL,
      93.773036,
      48.195787,
      6.062733,
      ' 7- 3-1988',
      NULL,
      NULL,
      ' 8-18-1979',
      5.624087,
      NULL,
      5.484434,
      10.742290,
      25.265641,
      7,
      NULL,
      14,
      NULL,
      101,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.335492,
      0,
      27,
      '10- 7-1974',
      2.463059,
      NULL,
      ' 7-11-1980',
      11.498270,
      NULL,
      NULL,
      NULL,
      ' 5- 9-2003',
      1.462122,
      NULL,
      37,
      ' 8- 2-1996',
      NULL,
      NULL,
      NULL,
      2.788606,
      NULL,
      1.486064,
      50.352251,
      NULL,
      10,
      29,
      15,
      21,
      49,
      NULL,
      40.299124,
      0,
      0,
      36.624605,
      NULL,
      NULL,
      NULL,
      0.692951,
      0.830495,
      NULL,
      2,
      4,
      148.170021,
      70,
      23,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.280132,
      0,
      0.427385,
      1.337527,
      52,
      31.323964,
      NULL,
      12.616102,
      37,
      17,
      1,
      12.646769,
      1,
      0,
      3.559844,
      5.387920,
      28.736195,
      0,
      3.672437,
      0,
      NULL,
      0,
      1.539253,
      60,
      12,
      21,
      36,
      59.712252,
      39.437213,
      13.511815,
      57,
      10.214930,
      5,
      0,
      NULL,
      1,
      NULL,
      1.992577,
      0,
      50,
      ' 7- 5-1974',
      ' 7- 0-2001',
      ' 4-15-1976',
      ' 0-28-2002',
      ' 9-16-2001',
      '11- 0-2003',
      NULL,
      NULL);
commit;
end;
/


