set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7112768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '0',
      '1',
      '2',
      '2',
      '0',
      NULL,
      NULL,
      '0',
      '4',
      '1',
      '1',
      '1',
      '2',
      '1',
      '1',
      '0',
      '0',
      NULL,
      '3',
      '2',
      '3',
      '1',
      '',
      '0',
      '',
      '1',
      '4',
      '0',
      '4',
      '1',
      NULL,
      '',
      NULL,
      '3',
      NULL,
      '4',
      '0',
      '3',
      '1',
      '4',
      '2',
      '2',
      '0',
      '420',
      '24434123',
      6,
      56,
      NULL,
      1.655661,
      1,
      3,
      NULL,
      '012222',
      4.281110,
      NULL,
      ' 4-27-1981',
      26.801374,
      167,
      17,
      NULL,
      41.489552,
      8.581126,
      15.941200,
      4,
      NULL,
      5,
      44,
      17.409198,
      48.813264,
      2.072497,
      35,
      22,
      1,
      NULL,
      29,
      17,
      51.996366,
      0.391811,
      92.439961,
      16.226460,
      1,
      20.397790,
      100.349069,
      NULL,
      183.311244,
      NULL,
      74.408694,
      ' 7-22-1975',
      68,
      8,
      9.445923,
      10.108650,
      213.595790,
      206.072819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66,
      12.766543,
      6.631926,
      8.692811,
      4,
      NULL,
      ' 3-17-1998',
      0,
      1,
      100,
      0.570512,
      NULL,
      17,
      0,
      1,
      47,
      NULL,
      NULL,
      NULL,
      ' 5-27-1998',
      33.262013,
      113.778083,
      105,
      81.002493,
      96.236907,
      22.157147,
      30,
      NULL,
      46.880805,
      NULL,
      22,
      NULL,
      ' 3-26-1975',
      NULL,
      41,
      NULL,
      71.656881,
      88,
      NULL,
      7.698599,
      ' 7- 6-2003',
      25,
      21,
      ' 7-21-1975',
      NULL,
      7.511241,
      12,
      7.521575,
      15,
      0.969608,
      0,
      13,
      0.820270,
      106,
      1.437379,
      NULL,
      1,
      19,
      NULL,
      0.037089,
      NULL,
      1,
      ' 3- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      133.301075,
      2.114705,
      ' 2-26-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-12-1989',
      NULL,
      NULL,
      3,
      8.931375,
      ' 2- 3-1980',
      91,
      142,
      ' 8- 8-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      21,
      ' 1-23-1990',
      40.745354,
      NULL,
      NULL,
      ' 0-17-1982',
      0.722738,
      39,
      ' 0- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


