set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8818301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '0',
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      '4',
      '0',
      '2',
      NULL,
      '4',
      '4',
      NULL,
      '3',
      NULL,
      NULL,
      '0',
      '3',
      '1',
      '',
      '0',
      '',
      '0',
      '2',
      NULL,
      '3',
      '2',
      '',
      NULL,
      '1',
      '2',
      '2',
      '2',
      NULL,
      '4',
      '2',
      '3',
      '4',
      '0',
      '3',
      NULL,
      '44042311',
      5,
      0,
      '2303200',
      3.912295,
      0.570347,
      NULL,
      0,
      '031143',
      NULL,
      ' 6-24-1981',
      '10-21-1990',
      NULL,
      57.800883,
      6.604951,
      24.779034,
      23.989485,
      19,
      NULL,
      13,
      26,
      19,
      34,
      3,
      NULL,
      17,
      30.765902,
      18.080238,
      7,
      2,
      17.179703,
      8,
      9.845131,
      NULL,
      17,
      14.427420,
      1.505299,
      127,
      216,
      35,
      145.604244,
      69.379897,
      2.794644,
      NULL,
      31.533734,
      26.507958,
      12,
      36,
      184,
      153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.588887,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 7-14-1993',
      0,
      1.067340,
      123,
      1.836155,
      1.621987,
      NULL,
      0.406883,
      1.071033,
      2,
      NULL,
      NULL,
      NULL,
      ' 5-14-1979',
      116.319691,
      12.230675,
      NULL,
      118.483070,
      117,
      34,
      NULL,
      81,
      5.011279,
      82.172846,
      89,
      89,
      ' 5-21-1989',
      10,
      16,
      29.869663,
      139,
      56.026993,
      43,
      NULL,
      ' 8- 1-1979',
      NULL,
      23.366199,
      NULL,
      1.517552,
      11.742632,
      NULL,
      14.977476,
      26.784254,
      5,
      1.960242,
      6.395360,
      NULL,
      24,
      1,
      3,
      NULL,
      12.966255,
      NULL,
      1.999248,
      0,
      1,
      ' 7- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      56.883409,
      2,
      ' 7-10-1982',
      NULL,
      NULL,
      NULL,
      40.763703,
      '10- 6-1997',
      NULL,
      '10- 0-1990',
      5.702702,
      6.615066,
      '10-16-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      ' 8- 8-2002',
      NULL,
      33.701979,
      36.333789,
      '10-13-1979',
      1,
      17.653934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


