set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1334',
      '43320331',
      '20234202',
      '34404441',
      '23211002',
      NULL,
      '44420203',
      '33022414',
      NULL,
      '20321221',
      '30140413',
      '10302444',
      NULL,
      '30444031',
      '13334221',
      '10022114',
      NULL,
      '10403230',
      '22200341',
      '11111224',
      '22412023',
      '42201221',
      NULL,
      '12022131',
      '43031404',
      NULL,
      NULL,
      '10204014',
      '34402233',
      '31204103',
      '01404011',
      '23434013',
      '01144220',
      '11321013',
      '43430043',
      '00032121',
      '14131111',
      NULL,
      '44430304',
      '43030300',
      '31004220',
      '30310031',
      '14411023',
      '14013104',
      '01214432',
      '',
      '',
      NULL,
      NULL,
      '3120244',
      1.250973,
      0,
      1,
      NULL,
      '333441',
      2.129360,
      ' 7-18-1994',
      ' 1-13-1999',
      39.766500,
      NULL,
      31,
      13,
      17,
      14,
      NULL,
      1.024941,
      0,
      NULL,
      7.673408,
      0,
      41.940015,
      8,
      10.775013,
      16.592965,
      7,
      5,
      42,
      4,
      61.704928,
      NULL,
      48,
      8.952650,
      NULL,
      2,
      191.475454,
      NULL,
      NULL,
      20.733575,
      98,
      ' 7-27-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507750,
      NULL,
      13.836409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199492,
      2.488646,
      0.954778,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-12-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-2000',
      151,
      18.436559,
      132,
      NULL,
      78.931243,
      NULL,
      48,
      37,
      45,
      NULL,
      57.273916,
      29.113711,
      ' 5- 0-1980',
      NULL,
      21.924964,
      36,
      NULL,
      49.961998,
      143,
      13,
      ' 6-12-1977',
      2.865649,
      0,
      ' 9-26-1987',
      6.665401,
      11.074583,
      15.615465,
      14,
      NULL,
      15,
      NULL,
      19,
      NULL,
      18.483233,
      1.970825,
      0.427414,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      17.191192,
      ' 5-23-1979',
      0,
      52.230869,
      '11-10-1979',
      0.368134,
      20,
      NULL,
      NULL,
      ' 3-24-1993',
      NULL,
      1,
      139.219130,
      '11-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      17.370821,
      NULL,
      NULL,
      26,
      NULL,
      16.374010,
      10.431956,
      7.381305,
      NULL,
      4,
      66.787866,
      5,
      0,
      24,
      1,
      3.719683,
      82,
      0.719015,
      6,
      NULL,
      5,
      11,
      NULL,
      62.699190,
      8,
      76,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.155318,
      1,
      1.577895,
      NULL,
      60,
      24,
      NULL,
      102.659252,
      NULL,
      1,
      0,
      76,
      1,
      12.173584,
      3.743613,
      NULL,
      0,
      50.920561,
      1.513135,
      NULL,
      NULL,
      NULL,
      113.092193,
      18.127811,
      1.667556,
      17,
      49,
      35,
      19,
      NULL,
      0.532469,
      6,
      0,
      12,
      NULL,
      3,
      NULL,
      4.864841,
      56.739842,
      '11-21-1987',
      ' 1-19-1979',
      '10-17-2003',
      ' 7- 4-1999',
      ' 8- 8-1977',
      ' 8-29-1978',
      NULL,
      NULL);
commit;
end;
/


