set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1322',
      '22110423',
      '42031113',
      '33004043',
      '31434042',
      '42421441',
      NULL,
      '40101024',
      '44041442',
      '10033232',
      '23031221',
      '04332242',
      '10233233',
      NULL,
      '13300230',
      '21024322',
      '00420043',
      '31142444',
      NULL,
      '01000313',
      NULL,
      '20314321',
      NULL,
      NULL,
      '00033423',
      '23203433',
      '11324022',
      '00120303',
      '41002001',
      '14213111',
      '34423320',
      '43102014',
      '42300044',
      '33341114',
      '04123441',
      '33200144',
      '20303132',
      '10114442',
      '01013310',
      '11431341',
      '11301121',
      '24321204',
      NULL,
      '40111104',
      '22201113',
      NULL,
      '21',
      NULL,
      NULL,
      '3234010',
      2.855750,
      NULL,
      0,
      NULL,
      '044302',
      NULL,
      ' 5-24-1983',
      ' 0-20-1975',
      23.451247,
      NULL,
      14,
      NULL,
      16.905940,
      19,
      91.527406,
      11.961884,
      19.941921,
      NULL,
      NULL,
      7.522240,
      31,
      1.118992,
      13,
      14.649317,
      9,
      17.714527,
      60,
      8,
      18.656387,
      7.382390,
      132.727630,
      18.972975,
      3,
      114,
      187.259072,
      33.496384,
      32,
      40,
      220,
      '11-11-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218272,
      2.161068,
      NULL,
      1.255650,
      3,
      0.799703,
      0.689819,
      0.388221,
      1,
      6.391042,
      1,
      NULL,
      4.632164,
      1,
      0.493296,
      1,
      0,
      0.786637,
      0.350532,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-2003',
      27,
      9,
      NULL,
      1,
      NULL,
      1.306914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      30,
      127,
      NULL,
      91,
      NULL,
      40,
      99,
      NULL,
      30.162147,
      1,
      54.933583,
      ' 4- 6-1977',
      17.996018,
      NULL,
      1.172158,
      43.181530,
      2,
      NULL,
      NULL,
      ' 5- 9-1980',
      16.535518,
      13.947740,
      '11-26-1980',
      15.423848,
      NULL,
      17,
      17.091571,
      11.586198,
      NULL,
      NULL,
      3.042293,
      1.873256,
      105,
      0,
      NULL,
      7,
      6,
      2.994322,
      3.054013,
      2.135039,
      0.749318,
      ' 1-25-2002',
      3.386284,
      1,
      5.836032,
      ' 2- 2-1992',
      68,
      47.312959,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      ' 6-25-1995',
      21.343612,
      ' 1-16-1983',
      0.878818,
      NULL,
      ' 5-17-1995',
      105,
      59,
      ' 0-20-1976',
      NULL,
      7,
      ' 3-15-1977',
      4,
      2,
      NULL,
      2,
      1,
      21.921879,
      NULL,
      50,
      21,
      35,
      '11-23-1980',
      1,
      66,
      ' 4-20-1986',
      2.063789,
      NULL,
      NULL,
      36.021144,
      ' 8-24-1979',
      13.604965,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14);
commit;
end;
/


