set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1041',
      '10410314',
      '22401234',
      NULL,
      '12312143',
      NULL,
      NULL,
      '21310321',
      '10204140',
      '43023342',
      '03244324',
      '40410201',
      '40002232',
      '10343144',
      '22200140',
      '44443144',
      '12302224',
      '24434042',
      NULL,
      '34022320',
      '41144002',
      '03004302',
      '31323023',
      NULL,
      '30444011',
      '01241433',
      NULL,
      '42411441',
      '14030241',
      '02330042',
      NULL,
      '42232201',
      NULL,
      '44003022',
      '04404122',
      '22324302',
      NULL,
      '14332100',
      '30130411',
      '33321114',
      '43402441',
      '01031102',
      NULL,
      '41220012',
      '34430431',
      '113',
      '32',
      NULL,
      NULL,
      '4041232',
      NULL,
      25,
      NULL,
      NULL,
      '032343',
      5.465310,
      ' 7-18-2002',
      '11-13-2001',
      67,
      NULL,
      22.788279,
      16,
      1,
      5.732913,
      27,
      13.899273,
      12.404111,
      25,
      40.537962,
      2,
      24.270152,
      18,
      29.689792,
      17,
      1.692576,
      4.520766,
      4,
      8,
      35.558064,
      10,
      40,
      9,
      1.065137,
      63.915533,
      NULL,
      NULL,
      40,
      109.684406,
      136,
      ' 8-21-1994',
      NULL,
      30,
      26,
      32,
      88,
      86,
      '10- 7-1985',
      0.194416,
      0,
      0.018677,
      0.428990,
      5.874879,
      0.171727,
      3,
      1.236823,
      NULL,
      0,
      2,
      1.462328,
      NULL,
      1,
      1.864338,
      3,
      NULL,
      1.930367,
      0.055767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.969098,
      19.808963,
      NULL,
      NULL,
      1,
      1,
      ' 9-23-1994',
      1,
      0,
      117.081849,
      1.569243,
      3.679516,
      90,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1974',
      NULL,
      103.297385,
      110,
      105.147108,
      35.868332,
      26.968994,
      40,
      83.736713,
      36.735614,
      108.338634,
      13.038418,
      8.653935,
      ' 6-15-1983',
      28.370119,
      NULL,
      25,
      NULL,
      NULL,
      107.350965,
      12.673596,
      NULL,
      6,
      10,
      ' 4- 8-1997',
      4.914474,
      2,
      13,
      15.406485,
      NULL,
      6,
      1.185468,
      NULL,
      1,
      68.005722,
      0.405885,
      10.649079,
      NULL,
      16.537720,
      NULL,
      2,
      7.929710,
      0.671146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      148,
      24,
      ' 2-20-1980',
      NULL,
      NULL,
      NULL,
      56.144491,
      ' 6- 1-1994',
      29.005499,
      ' 2-22-1980',
      1.389035,
      15.834260,
      ' 2- 2-2003',
      61,
      NULL,
      ' 4- 0-2001',
      2.399556,
      1.736490,
      ' 3-23-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.499603,
      NULL,
      59.264479,
      12.764526,
      NULL,
      '11- 6-1997',
      0.328001,
      49,
      ' 3- 9-1978',
      0,
      62.628496,
      8,
      NULL,
      ' 3-24-1990',
      61,
      1.511753,
      NULL,
      ' 8- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


