set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      '1',
      '3',
      '2',
      '3',
      '4',
      NULL,
      NULL,
      '0',
      NULL,
      '0',
      '4',
      '3',
      '0',
      '4',
      '4',
      '1',
      '0',
      '0',
      '0',
      '1',
      NULL,
      '',
      '3',
      '',
      '2',
      '1',
      '1',
      '3',
      '0',
      '',
      NULL,
      '0',
      '2',
      '4',
      '2',
      '0',
      '1',
      '4',
      '2',
      NULL,
      '0',
      '3',
      '140',
      '04',
      NULL,
      NULL,
      NULL,
      NULL,
      186,
      0,
      NULL,
      '240004',
      0,
      ' 5- 9-2001',
      '10-22-1989',
      15.623545,
      203.997968,
      NULL,
      NULL,
      27.696104,
      NULL,
      89.757217,
      23.900310,
      15,
      17.319814,
      1,
      0.535347,
      26,
      23,
      NULL,
      3,
      36,
      9,
      53.778440,
      15,
      4,
      NULL,
      58,
      18.416721,
      NULL,
      99,
      7,
      NULL,
      6.545655,
      49,
      NULL,
      ' 1-27-1994',
      28.171838,
      11.351527,
      21,
      27,
      136.572815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.926754,
      1.366625,
      4.742232,
      2.328400,
      0.842907,
      1.444767,
      NULL,
      NULL,
      1.047218,
      153.022639,
      1.959070,
      NULL,
      NULL,
      NULL,
      1.758587,
      67.844381,
      NULL,
      NULL,
      NULL,
      ' 4-12-1976',
      52,
      58,
      41.770898,
      56.044915,
      NULL,
      38,
      57.442784,
      0.221292,
      95,
      82.047167,
      74.099674,
      7.173032,
      ' 9-21-1976',
      13,
      39.722763,
      NULL,
      NULL,
      47.892490,
      116.380039,
      11.882460,
      ' 0-23-1998',
      14,
      13,
      ' 9-14-1974',
      11,
      0,
      NULL,
      3,
      13.666821,
      6,
      3.694181,
      NULL,
      1.585810,
      88,
      NULL,
      0,
      NULL,
      1.038475,
      0,
      0.577928,
      NULL,
      1.554284,
      ' 0-25-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      149,
      7.483151,
      ' 0-21-1982',
      NULL,
      NULL,
      NULL,
      24.236685,
      ' 0-27-1992',
      23.068737,
      ' 0-15-1976',
      8,
      2,
      ' 7- 5-1999',
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      ' 9- 9-1984',
      60.239295,
      32,
      5,
      ' 7-20-1980',
      NULL,
      42.879022,
      '11-12-1994',
      18.473545,
      35.137853,
      1,
      20.833324,
      ' 8- 1-1997',
      17.910020,
      0,
      95,
      ' 6- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


