set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9115325';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4144',
      '32243444',
      '31031000',
      '01443333',
      '04303142',
      '21210114',
      '12442134',
      '01200242',
      '10041441',
      '02113444',
      '22133414',
      '13431001',
      '41401232',
      '31032043',
      '40231241',
      '10243210',
      '33020010',
      NULL,
      NULL,
      '24432423',
      '40022434',
      '21214322',
      '20113202',
      NULL,
      '14002032',
      '44221044',
      '30434034',
      '11401413',
      '34210310',
      '02224120',
      NULL,
      '12434430',
      '44232141',
      '12240430',
      '00414431',
      '11221022',
      '43242142',
      '33320321',
      NULL,
      NULL,
      '14101134',
      '14234030',
      '31112214',
      '41202233',
      '03331433',
      '401',
      '03',
      NULL,
      NULL,
      '1232243',
      NULL,
      NULL,
      NULL,
      NULL,
      '042034',
      NULL,
      ' 3-27-1984',
      ' 9-25-1978',
      9.003665,
      NULL,
      10,
      NULL,
      2,
      11,
      67.886933,
      8.031759,
      NULL,
      7,
      21.959729,
      5.724565,
      13,
      NULL,
      27,
      6.730394,
      20.877291,
      20,
      82,
      9.630113,
      70.978458,
      13.221088,
      27,
      9,
      NULL,
      80,
      41,
      38,
      NULL,
      20,
      42,
      '11- 7-2000',
      39.177863,
      15,
      NULL,
      40.949088,
      171,
      0.681743,
      NULL,
      0,
      0,
      1.785273,
      1,
      0.047883,
      0.794106,
      2.453243,
      1,
      1,
      0.160666,
      1.443405,
      1,
      0,
      0.776432,
      0.024749,
      0.515203,
      0,
      NULL,
      1.223708,
      1.892744,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1974',
      15.995470,
      27,
      NULL,
      4.534223,
      14.360996,
      5,
      ' 7-14-1982',
      NULL,
      0,
      196.624855,
      1,
      1,
      NULL,
      0.457802,
      NULL,
      56.090207,
      0.677511,
      NULL,
      189,
      ' 6-21-1996',
      44.887429,
      19.961927,
      98.901223,
      NULL,
      49,
      64.440732,
      NULL,
      32.537708,
      73,
      NULL,
      28,
      45.296257,
      ' 1-20-1977',
      23,
      6,
      7,
      77.104807,
      48.709855,
      NULL,
      4.813955,
      ' 6-12-1995',
      34,
      23,
      ' 0-24-1994',
      NULL,
      6,
      10.113505,
      NULL,
      14,
      13.229492,
      1.488900,
      8.898456,
      0,
      NULL,
      9,
      NULL,
      21,
      4.385779,
      NULL,
      NULL,
      2,
      0,
      '11- 7-1991',
      3,
      3.494490,
      NULL,
      '11-28-1976',
      167,
      23,
      ' 5- 6-1995',
      14.418113,
      18,
      '11-13-1984',
      46,
      ' 4- 6-1985',
      23,
      ' 0-19-1992',
      NULL,
      NULL,
      ' 8-18-1994',
      25.952201,
      NULL,
      ' 5-12-2000',
      8,
      1.342795,
      '11-12-1986',
      NULL,
      13,
      ' 2- 1-1976',
      NULL,
      2,
      NULL,
      ' 6- 4-1993',
      18.280149,
      14.325594,
      44,
      ' 1-26-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


