set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5616727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431',
      '32034312',
      '00442312',
      NULL,
      '01120242',
      '40012230',
      '13111323',
      '00200142',
      NULL,
      '40133000',
      '42103030',
      '21241241',
      '22220031',
      '14323330',
      '42102201',
      '12422143',
      '13020124',
      '01131203',
      NULL,
      NULL,
      '34224200',
      '13301030',
      NULL,
      '01004133',
      '11344440',
      '32302240',
      NULL,
      '41430041',
      '44412132',
      NULL,
      '11111332',
      '43330101',
      '02214342',
      '01242040',
      '01010044',
      '41211241',
      '00131123',
      '32201234',
      '03324034',
      '03440433',
      '11233112',
      '44103132',
      NULL,
      '22143302',
      '12141301',
      '413',
      '40',
      4.569627,
      11,
      '2403233',
      2,
      0,
      1,
      NULL,
      '224204',
      5.979134,
      NULL,
      NULL,
      36.244762,
      0,
      NULL,
      6.068015,
      NULL,
      12,
      115.394240,
      NULL,
      14,
      NULL,
      35.988852,
      11,
      0.368243,
      3,
      3.719068,
      7,
      15,
      1,
      44.268515,
      NULL,
      NULL,
      2.777625,
      74.469625,
      10,
      1,
      40,
      49,
      64.855852,
      NULL,
      231.846270,
      63.600348,
      ' 4-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605687,
      0.953891,
      NULL,
      0.226577,
      3.491714,
      13,
      1,
      1,
      22,
      NULL,
      NULL,
      NULL,
      ' 5-11-1996',
      62,
      51,
      73.145964,
      69,
      69.658759,
      62,
      13.898618,
      NULL,
      NULL,
      83.328253,
      78.066384,
      38,
      '11-20-1989',
      8,
      14.683788,
      4.092728,
      55,
      59,
      20,
      1,
      ' 9-22-1985',
      NULL,
      NULL,
      NULL,
      1,
      15,
      NULL,
      NULL,
      6.606672,
      2.098882,
      2.734958,
      2.686629,
      0,
      NULL,
      1.836323,
      3.365471,
      3.730761,
      26.492233,
      2.371124,
      1.928223,
      NULL,
      0,
      ' 1-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      113,
      NULL,
      ' 7-18-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      '11- 8-1975',
      41.625651,
      6.201400,
      15,
      '10-12-1999',
      1.710268,
      NULL,
      ' 2-24-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


