set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '4',
      '1',
      '2',
      '0',
      '2',
      NULL,
      '4',
      '1',
      '1',
      '3',
      '3',
      '3',
      '3',
      '3',
      NULL,
      '2',
      '3',
      '2',
      '4',
      NULL,
      '3',
      '4',
      '',
      '0',
      '',
      '3',
      '0',
      NULL,
      '0',
      '3',
      '',
      NULL,
      '1',
      '2',
      '3',
      '2',
      '4',
      '3',
      '0',
      '0',
      '2',
      '1',
      '1',
      '234',
      '20122110',
      63.227792,
      48.728895,
      '4012002',
      2.840083,
      NULL,
      2,
      NULL,
      '203222',
      3,
      ' 4- 6-1986',
      NULL,
      NULL,
      26,
      18,
      10,
      NULL,
      10.751858,
      6.925920,
      10,
      19.431552,
      NULL,
      15.986715,
      9.512258,
      NULL,
      7.077049,
      2,
      3.122239,
      15,
      8,
      NULL,
      8,
      NULL,
      9.677015,
      82,
      NULL,
      NULL,
      98,
      171.494174,
      46.290219,
      115.946004,
      82.039770,
      126,
      ' 6-27-1976',
      NULL,
      NULL,
      NULL,
      9,
      135.507790,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.977801,
      29,
      18,
      3,
      11.230713,
      7.296419,
      '11-16-1990',
      0.432734,
      1,
      109.918595,
      NULL,
      3,
      53,
      1.765372,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65.630163,
      16,
      6,
      82,
      NULL,
      77.093800,
      93,
      72,
      24,
      NULL,
      NULL,
      ' 4- 3-1975',
      6.781714,
      0,
      18,
      45.170756,
      NULL,
      NULL,
      4,
      ' 0-14-1998',
      NULL,
      4,
      ' 6- 0-1975',
      NULL,
      5,
      5.892961,
      11.482723,
      22,
      9,
      0.490732,
      9,
      0.986130,
      114,
      NULL,
      0.438216,
      1.864431,
      7,
      7,
      3.460409,
      1,
      1,
      ' 7- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      ' 2-12-1982',
      NULL,
      NULL,
      NULL,
      32,
      ' 3-23-1979',
      45.250171,
      ' 3-29-1994',
      1,
      NULL,
      ' 3-28-1984',
      NULL,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      ' 9- 1-1991',
      55.802888,
      12.332861,
      13,
      ' 9-27-1995',
      0,
      12.358201,
      NULL,
      0.510818,
      25.157050,
      18.143888,
      58.889098,
      NULL,
      64,
      1,
      81,
      ' 1-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


