set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914220';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2311',
      '14241123',
      NULL,
      '12443440',
      NULL,
      NULL,
      '14203404',
      NULL,
      '10200412',
      '03140213',
      '04432034',
      '40110430',
      '34440022',
      '14100112',
      '14314430',
      '14031224',
      NULL,
      '44343004',
      '04014214',
      NULL,
      '02414324',
      '12033114',
      '21310033',
      '21122311',
      NULL,
      '33134404',
      '20140413',
      '40404204',
      '33021013',
      '03234022',
      '43041324',
      '22243341',
      NULL,
      NULL,
      NULL,
      NULL,
      '41002334',
      '41432003',
      '41311401',
      '22403442',
      NULL,
      '23320021',
      '21020144',
      NULL,
      '11421422',
      '',
      '',
      NULL,
      NULL,
      '4200310',
      0.042942,
      1.842714,
      0,
      NULL,
      '343021',
      0.007234,
      ' 0-23-1983',
      ' 9-21-1997',
      80.214003,
      NULL,
      2.588828,
      6,
      8.350760,
      15,
      56.417829,
      8,
      NULL,
      5,
      28,
      23.004762,
      27,
      7,
      11,
      7.883302,
      20,
      16,
      28,
      10.059874,
      50.142606,
      NULL,
      28.846365,
      20.869885,
      NULL,
      58,
      8,
      NULL,
      190.465672,
      124,
      NULL,
      ' 1- 7-2000',
      27,
      NULL,
      10,
      15.990900,
      157.919431,
      126,
      ' 3-18-1991',
      2,
      0,
      NULL,
      0.283945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733553,
      4.085932,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-12-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-16-1987',
      109,
      89,
      31.578382,
      NULL,
      74,
      68,
      40.311789,
      NULL,
      24,
      NULL,
      59.666749,
      111.442700,
      ' 8- 8-2000',
      NULL,
      8.427416,
      NULL,
      NULL,
      11.177389,
      46,
      8,
      ' 5-27-1980',
      16,
      NULL,
      ' 0-10-1974',
      4.550069,
      10.145906,
      9.179571,
      19.190135,
      17,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.277161,
      NULL,
      NULL,
      ' 6-15-1983',
      1.315073,
      37.092404,
      NULL,
      6.738423,
      30.223984,
      9.090073,
      22,
      ' 2-21-2003',
      NULL,
      1.692522,
      79,
      ' 6-16-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      26.024110,
      0,
      NULL,
      NULL,
      98.986979,
      9.596304,
      6.724045,
      7,
      11.282430,
      4.172466,
      NULL,
      1,
      0,
      59,
      NULL,
      NULL,
      NULL,
      0.416320,
      1,
      50,
      11.489277,
      2,
      42,
      NULL,
      10.251402,
      NULL,
      0.657172,
      NULL,
      1,
      0,
      0.176347,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      2.996488,
      0,
      3.046080,
      0.535909,
      8.760927,
      NULL,
      NULL,
      0.506407,
      NULL,
      0,
      NULL,
      1,
      3.792113,
      NULL,
      5.765737,
      7.547947,
      24,
      NULL,
      NULL,
      21.849822,
      NULL,
      11,
      8.099754,
      0,
      NULL,
      3,
      3,
      NULL,
      1.448202,
      NULL,
      ' 3- 3-1983',
      ' 3-14-2003',
      ' 5-13-1974',
      '10-18-1985',
      NULL,
      ' 0-23-1987',
      ' 6-11-1996',
      NULL);
commit;
end;
/


