set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2343',
      '34113021',
      '22241220',
      NULL,
      '04400341',
      '11140040',
      '40043221',
      '12132400',
      '30122141',
      '14441423',
      '04034110',
      '21424302',
      '02143022',
      '30232043',
      '44440321',
      NULL,
      '13322112',
      '01104332',
      '42143424',
      '10323300',
      '11313234',
      '33321320',
      '04212404',
      '34413041',
      NULL,
      '31034143',
      '24120323',
      NULL,
      '44021112',
      '02211330',
      '22432314',
      '22442224',
      NULL,
      '14041341',
      NULL,
      '40042311',
      '43410333',
      NULL,
      NULL,
      '04204204',
      '31114412',
      '13232210',
      NULL,
      '00220234',
      '03233333',
      '',
      '',
      NULL,
      NULL,
      '3334342',
      0.857771,
      NULL,
      0,
      NULL,
      '102014',
      NULL,
      ' 1-13-1976',
      ' 4-23-1979',
      32.818896,
      NULL,
      32.471379,
      17.092946,
      23,
      21,
      31.015430,
      20.236638,
      17.975639,
      12,
      NULL,
      5,
      34.666077,
      NULL,
      NULL,
      7,
      19,
      9,
      NULL,
      3.725206,
      15.257006,
      NULL,
      NULL,
      11.530247,
      NULL,
      49,
      36.110689,
      NULL,
      66.455085,
      64,
      140,
      ' 1-29-2003',
      37.405443,
      18.577087,
      27,
      4.237955,
      33.672892,
      152.682650,
      NULL,
      1.207943,
      NULL,
      1.097957,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517240,
      0.738613,
      3.152033,
      1.568737,
      0,
      0.229797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-16-1979',
      NULL,
      NULL,
      64,
      47.110519,
      9,
      NULL,
      104.189107,
      NULL,
      17.755932,
      NULL,
      45,
      47,
      '11-12-1978',
      14,
      37,
      31.649482,
      68,
      4,
      NULL,
      3.828492,
      ' 2-21-1987',
      NULL,
      21.782285,
      NULL,
      5.681833,
      10,
      15,
      6.581171,
      14.695842,
      2.293063,
      NULL,
      6.907600,
      NULL,
      23.157663,
      1.784407,
      0.515872,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      NULL,
      13,
      ' 7-26-1980',
      1,
      90.818332,
      ' 8-28-1997',
      0.778064,
      45.311761,
      9,
      9.483962,
      ' 6-11-1994',
      2.244266,
      NULL,
      123.913283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      190,
      0,
      NULL,
      82.306932,
      NULL,
      56.681347,
      25.374976,
      16.238525,
      NULL,
      7,
      97,
      1.755296,
      0.430666,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.795994,
      NULL,
      0.339612,
      0,
      63,
      27,
      NULL,
      1.852809,
      0,
      130.866610,
      0,
      0.799363,
      0,
      7,
      1.810188,
      1.085460,
      NULL,
      39.607363,
      141.842595,
      9,
      105,
      19.595563,
      1.992865,
      1.177506,
      26.004517,
      0.592604,
      0,
      1.806617,
      38,
      1,
      115,
      1,
      125.934438,
      1.954800,
      NULL,
      90,
      31.817408,
      11.337912,
      9.953992,
      54.457447,
      86,
      20.123488,
      65.685396,
      13,
      3.877014,
      1.286593,
      NULL,
      0.133917,
      0,
      0,
      1.832654,
      89,
      ' 3- 4-1981',
      ' 5-15-1982',
      NULL,
      ' 5-15-2003',
      ' 4-18-1991',
      NULL,
      ' 3-25-1980',
      NULL);
commit;
end;
/


