set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0140',
      NULL,
      '32441224',
      '42114333',
      NULL,
      '11213112',
      '33243304',
      '41411314',
      NULL,
      NULL,
      '40344414',
      '10321140',
      '24013431',
      NULL,
      '24441221',
      '42200033',
      '40031122',
      '40222230',
      '31320304',
      '00301040',
      '03040333',
      '34332033',
      '24203211',
      NULL,
      '32104100',
      '20324340',
      '33110014',
      '40211043',
      '34322322',
      NULL,
      '34430421',
      '43402212',
      '22341201',
      '23304014',
      NULL,
      '14134023',
      '04013032',
      '12313332',
      NULL,
      '02111224',
      '14340320',
      NULL,
      NULL,
      '44242411',
      NULL,
      '310',
      '11',
      NULL,
      NULL,
      '1240224',
      0,
      15.735290,
      NULL,
      NULL,
      '013320',
      3,
      ' 1- 8-1990',
      ' 1-28-1975',
      111,
      NULL,
      29.636841,
      10,
      32,
      17.085646,
      62.772914,
      9,
      1,
      NULL,
      NULL,
      15,
      3.130217,
      1.987272,
      0.577048,
      NULL,
      3.602735,
      NULL,
      13,
      9.241080,
      NULL,
      3,
      15.909986,
      19.350586,
      0.521642,
      13,
      166.082764,
      70.076580,
      48,
      124.763312,
      39.762138,
      ' 4- 4-1980',
      44.719060,
      NULL,
      1,
      21,
      59.420676,
      NULL,
      ' 0- 0-1991',
      2,
      0.950428,
      1,
      0,
      NULL,
      0.270335,
      0,
      0.356369,
      1.400170,
      0,
      0.933706,
      0,
      1.236190,
      1.869506,
      1.892400,
      1,
      1,
      0,
      1.497909,
      3.031312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.530136,
      31.375165,
      6,
      NULL,
      1.514596,
      0.435214,
      '10- 4-1990',
      0.907315,
      1,
      231.910186,
      0.900268,
      2.858456,
      49.183015,
      NULL,
      1.581943,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 1-1974',
      71,
      5.536337,
      23.915477,
      NULL,
      NULL,
      62.444198,
      6,
      84,
      33,
      80.788585,
      63,
      NULL,
      ' 9-21-1988',
      8.849798,
      NULL,
      27.856536,
      NULL,
      76.048138,
      52,
      NULL,
      NULL,
      15,
      5,
      ' 8-28-1991',
      NULL,
      14,
      NULL,
      NULL,
      5,
      17,
      1.264678,
      11,
      1,
      5,
      0.105499,
      3,
      NULL,
      23,
      1.419004,
      NULL,
      NULL,
      1.270497,
      '10-21-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      ' 4-27-1981',
      NULL,
      NULL,
      NULL,
      34.070158,
      ' 4- 8-1977',
      13,
      ' 3-15-1984',
      4.923157,
      6,
      ' 2-19-1993',
      89.746053,
      40,
      NULL,
      4,
      0,
      ' 8-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 4- 6-1987',
      6.636289,
      17,
      39.184949,
      '10-15-1985',
      NULL,
      189,
      ' 0- 8-1988',
      2,
      21.735715,
      10.052117,
      33,
      '10- 7-1989',
      NULL,
      1.233344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


