set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4212',
      '13111014',
      '03110201',
      '44044122',
      '04230130',
      '43131124',
      '12123230',
      '30202304',
      NULL,
      '30133132',
      NULL,
      '42422243',
      '00111120',
      '14304424',
      '23000214',
      '40322041',
      NULL,
      '10122323',
      '12341400',
      '34244401',
      '41220204',
      '33321234',
      '12414234',
      '31112442',
      '40331304',
      '32301001',
      NULL,
      '14122211',
      '00422110',
      '44211413',
      '34320442',
      '12241121',
      '42313134',
      '23423312',
      '24143021',
      '03204240',
      NULL,
      '14433122',
      NULL,
      '31220420',
      '34000204',
      '00201402',
      '31000031',
      '44430030',
      '30044004',
      '103',
      '12',
      3,
      7.408365,
      '0002200',
      3,
      57,
      2,
      NULL,
      '333243',
      NULL,
      ' 5-10-1994',
      ' 3-14-1991',
      0,
      63,
      7,
      0.706465,
      17.159158,
      10,
      12,
      NULL,
      NULL,
      10.012611,
      26.021844,
      9.604879,
      18.729861,
      13,
      13,
      3,
      2,
      8,
      NULL,
      14,
      5.178505,
      NULL,
      NULL,
      7.509454,
      NULL,
      47,
      125,
      NULL,
      84.621679,
      6,
      60.213659,
      NULL,
      NULL,
      5.448866,
      29,
      19.484723,
      20,
      86,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.653969,
      3.263011,
      13,
      5,
      3.700505,
      1,
      '11-24-1992',
      1,
      1.739083,
      168,
      0.392194,
      0.471576,
      NULL,
      1.964683,
      0.105154,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-14-1995',
      63.109496,
      22,
      NULL,
      72,
      76,
      NULL,
      17.881614,
      38.531212,
      NULL,
      5.452833,
      70.675692,
      NULL,
      ' 0- 8-1998',
      9,
      NULL,
      23,
      22.958624,
      74.739590,
      NULL,
      NULL,
      ' 0-18-1984',
      27,
      NULL,
      NULL,
      6,
      6.979824,
      NULL,
      NULL,
      17.501913,
      NULL,
      1.276286,
      21.594323,
      0.275645,
      17,
      1.638955,
      3.141448,
      NULL,
      NULL,
      NULL,
      5,
      1.066925,
      0.179112,
      ' 6-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      63.413349,
      39,
      ' 3-24-1987',
      NULL,
      NULL,
      NULL,
      25.100776,
      NULL,
      6.690569,
      NULL,
      2.232744,
      11,
      ' 9-25-1984',
      4,
      93.250463,
      ' 7-12-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      20,
      '10-27-1996',
      27.072593,
      14,
      24.273084,
      NULL,
      5,
      17.526760,
      ' 7-29-1974',
      6.214600,
      23,
      8.819431,
      11,
      ' 4-18-1975',
      5.989867,
      NULL,
      95,
      ' 4- 9-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


