set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      '1',
      NULL,
      NULL,
      '2',
      '1',
      '3',
      '3',
      NULL,
      '1',
      NULL,
      '2',
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '4',
      '4',
      '0',
      '2',
      NULL,
      NULL,
      '',
      '3',
      '1',
      '1',
      '0',
      '4',
      '',
      '',
      '2',
      '2',
      '3',
      NULL,
      '1',
      '4',
      '3',
      '4',
      '2',
      '3',
      '3',
      NULL,
      '31104403',
      27.347915,
      31.990117,
      '4134324',
      3,
      7,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-25-1984',
      NULL,
      6,
      252,
      0.004986,
      6.048854,
      NULL,
      16,
      50.424670,
      7,
      1.041837,
      9,
      10.106375,
      NULL,
      17.530747,
      23.680478,
      NULL,
      NULL,
      2.287190,
      NULL,
      4,
      10,
      4,
      12,
      62,
      9,
      0,
      18,
      131.470537,
      NULL,
      156,
      1,
      164,
      ' 2-18-1981',
      64.980242,
      NULL,
      NULL,
      25,
      19.922637,
      115,
      '11-15-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      31,
      NULL,
      17,
      0.280215,
      2.947216,
      ' 9-19-2003',
      1,
      1,
      183.167359,
      1,
      2.089516,
      48.134033,
      NULL,
      1.751942,
      56.821782,
      NULL,
      NULL,
      NULL,
      ' 4-15-1990',
      NULL,
      57.820382,
      4.902148,
      45,
      37.275039,
      13,
      52,
      64,
      10,
      62,
      NULL,
      71.210670,
      NULL,
      7,
      3,
      8.015470,
      43,
      64,
      73.815692,
      10.522993,
      ' 1-15-1975',
      25.815079,
      1,
      ' 0- 3-1996',
      8.311577,
      8,
      2,
      15,
      NULL,
      3.340895,
      0.968449,
      NULL,
      0,
      80,
      1.883538,
      1,
      10.633682,
      22.098397,
      1.835640,
      8,
      NULL,
      0.800828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.095271,
      16.264339,
      NULL,
      NULL,
      NULL,
      NULL,
      22.251781,
      '11-17-1978',
      NULL,
      ' 2-10-1988',
      11,
      8,
      ' 5-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      27,
      19.232551,
      11.087355,
      ' 4-13-1993',
      0.633729,
      158,
      ' 3-16-1998',
      1,
      31.560619,
      5,
      NULL,
      ' 8- 5-1985',
      41.972855,
      1,
      42,
      ' 7- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


