set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      '2',
      '0',
      NULL,
      '3',
      '0',
      NULL,
      '4',
      '4',
      NULL,
      '4',
      '0',
      '4',
      '1',
      '3',
      '3',
      NULL,
      '4',
      '2',
      '2',
      '4',
      '3',
      '4',
      '',
      '2',
      '',
      '2',
      '3',
      '3',
      '0',
      '3',
      '',
      '',
      NULL,
      '4',
      '3',
      '3',
      '0',
      '0',
      '1',
      '4',
      NULL,
      '1',
      '1',
      '420',
      '21324020',
      42.974039,
      41,
      '2304342',
      NULL,
      106,
      1,
      0,
      '132333',
      NULL,
      ' 2-23-1999',
      ' 7- 8-1977',
      49,
      32,
      37,
      9.273778,
      16,
      1.375763,
      56,
      3,
      12,
      4,
      4.000846,
      NULL,
      NULL,
      7.105507,
      10,
      0.078869,
      3,
      0,
      NULL,
      4,
      25,
      1,
      20,
      5.809781,
      0.259655,
      47,
      147,
      NULL,
      20,
      89,
      151,
      ' 8-24-1983',
      NULL,
      37,
      12,
      19.208013,
      107,
      119.474582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      18.146792,
      7.592901,
      27.279725,
      13.162875,
      1,
      ' 8- 2-1989',
      0,
      1.552309,
      NULL,
      0.622928,
      0.501085,
      71,
      0,
      0.677143,
      55.994399,
      NULL,
      NULL,
      NULL,
      '11- 6-1998',
      39,
      NULL,
      NULL,
      86.247535,
      NULL,
      NULL,
      4,
      6.468584,
      34,
      4.299124,
      37,
      48,
      NULL,
      11,
      25,
      NULL,
      20,
      8,
      148.899280,
      6,
      ' 1-13-2000',
      3,
      NULL,
      ' 8-22-2002',
      1.788851,
      0,
      8,
      NULL,
      19,
      NULL,
      0,
      15,
      0,
      26,
      0,
      1,
      NULL,
      22.729349,
      0,
      1.130017,
      1.268634,
      NULL,
      ' 4-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      66.414694,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      37.073881,
      ' 5-25-1992',
      42.105194,
      NULL,
      2.578870,
      4,
      ' 8- 4-1981',
      68,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      ' 6-22-2002',
      8.712755,
      15.721613,
      5.766668,
      '10- 9-2000',
      3.985120,
      38,
      NULL,
      3.535300,
      NULL,
      10,
      21,
      ' 9-21-1996',
      36.892776,
      0.973251,
      19,
      ' 1-10-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


