set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1203',
      '32231434',
      '43341333',
      '02201414',
      '30013233',
      '41312004',
      '12224313',
      '13430024',
      NULL,
      '20201024',
      '42243041',
      '32003321',
      '02024142',
      '32312303',
      '14133144',
      '33023440',
      '20344340',
      NULL,
      '40333031',
      NULL,
      '31021100',
      '43412100',
      NULL,
      '11003130',
      '12411232',
      '31402200',
      '30203240',
      '31404410',
      '13322442',
      NULL,
      '03414231',
      '32432312',
      '21444304',
      NULL,
      '21011402',
      '03421220',
      '00012203',
      NULL,
      '11432431',
      '04322244',
      '33233213',
      '30440243',
      NULL,
      '43311213',
      '32240110',
      '042',
      '41',
      NULL,
      NULL,
      '4014320',
      3.052385,
      0,
      3,
      NULL,
      '200241',
      5.089275,
      ' 9- 4-2002',
      ' 6-17-1978',
      84.108313,
      NULL,
      8,
      5,
      12,
      NULL,
      30,
      4.373132,
      9,
      2.369946,
      2,
      2.373994,
      23,
      14.200177,
      6.511522,
      NULL,
      NULL,
      3,
      26.276317,
      11.732535,
      55.052036,
      9.858501,
      70.643120,
      1,
      1.607518,
      47,
      4,
      45,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1995',
      17,
      NULL,
      5.124025,
      NULL,
      5.338603,
      83.564359,
      NULL,
      0.196511,
      0.006768,
      3,
      NULL,
      19.055436,
      1.506029,
      6.923860,
      5.885486,
      0,
      1.717083,
      16,
      1.618924,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1974',
      NULL,
      36.685579,
      27.495399,
      8,
      26.829981,
      1.200623,
      NULL,
      NULL,
      0.726642,
      70.542649,
      0.167992,
      NULL,
      28,
      1.780244,
      7,
      23.873685,
      NULL,
      NULL,
      NULL,
      '10-12-1995',
      NULL,
      7,
      0,
      NULL,
      34.378814,
      23.861891,
      34,
      4,
      NULL,
      3.772658,
      65,
      36,
      ' 0-18-1984',
      16,
      1,
      NULL,
      9,
      23,
      0,
      1,
      NULL,
      NULL,
      5.047703,
      ' 9- 1-2002',
      NULL,
      13,
      NULL,
      18,
      10,
      6.321988,
      2,
      21.641865,
      1.041207,
      17.557528,
      0.952334,
      15,
      14.164701,
      14.532061,
      0.992121,
      0,
      2.796258,
      1,
      NULL,
      3,
      1.293050,
      0,
      '10-18-1978',
      86,
      9,
      ' 6- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 6-2000',
      NULL,
      NULL,
      13,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.472101,
      0,
      '11-15-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      25.581082,
      ' 9-25-1997',
      7.608963,
      NULL,
      36.049748,
      ' 0-17-1990',
      NULL,
      NULL,
      NULL,
      2,
      118,
      NULL,
      30.936626,
      ' 4-10-1983',
      35,
      NULL,
      NULL,
      ' 7-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.450873);
commit;
end;
/


