set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0303',
      '21341004',
      '33022232',
      NULL,
      '22342110',
      '21222212',
      '30101034',
      '40311422',
      '01400341',
      '24144211',
      '30114020',
      NULL,
      '04004201',
      '04223341',
      NULL,
      NULL,
      NULL,
      '11414334',
      '23343112',
      '20213122',
      NULL,
      '03102212',
      '30312430',
      '02014433',
      '14130221',
      '02240322',
      '21323214',
      '11202201',
      '23100000',
      '02210244',
      '20012341',
      '20302120',
      '21203040',
      '01120413',
      '24041121',
      '20422022',
      '20241404',
      '24232003',
      NULL,
      '40224223',
      '42304003',
      '20133321',
      '13121344',
      '43202342',
      '04003241',
      '203',
      NULL,
      NULL,
      NULL,
      '2424102',
      2,
      11.269683,
      0,
      NULL,
      '443341',
      5,
      ' 9-23-1998',
      ' 9-23-1981',
      26.276140,
      NULL,
      NULL,
      10,
      5.284825,
      10.443560,
      NULL,
      NULL,
      1,
      17.751656,
      21,
      3,
      26.333030,
      13.341901,
      26,
      6.225306,
      7.567085,
      9.422371,
      20.454012,
      5,
      43,
      7.718718,
      40.635422,
      NULL,
      0.297955,
      78.762606,
      130.579318,
      26.443413,
      NULL,
      NULL,
      NULL,
      ' 8-15-1987',
      6.316465,
      24,
      5.307024,
      13.409814,
      71.632417,
      155,
      ' 5-25-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.723360,
      NULL,
      21.755319,
      NULL,
      2.601526,
      0,
      ' 9-23-1986',
      1,
      3,
      82.683707,
      1,
      7,
      12.867475,
      1.785403,
      6.143740,
      10.708758,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1977',
      36,
      27,
      NULL,
      54,
      57.099183,
      39,
      30.986903,
      22,
      NULL,
      72.412118,
      8.881010,
      13.972528,
      '11-23-1981',
      14,
      NULL,
      13,
      54,
      8.298008,
      48.057791,
      8.020007,
      '11-14-1990',
      7,
      11,
      ' 7- 4-1979',
      NULL,
      NULL,
      15.182495,
      15.075542,
      4,
      0,
      0,
      23.174267,
      0,
      76.395994,
      13.436897,
      8.017453,
      11,
      30.347093,
      1,
      0,
      0.594726,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.438593,
      NULL,
      NULL,
      ' 3-20-1990',
      NULL,
      NULL,
      ' 0-12-1994',
      NULL,
      10,
      NULL,
      6.032977,
      0,
      ' 0- 4-1975',
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      ' 1-18-1993',
      NULL,
      NULL,
      22.684463,
      ' 9-22-1984',
      1.499335,
      81.439519,
      ' 7- 0-1985',
      9,
      120.980294,
      22,
      61,
      ' 3-18-1995',
      NULL,
      NULL,
      NULL,
      ' 9- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


