set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1301',
      NULL,
      '31210204',
      '21002111',
      '10444032',
      '23042303',
      NULL,
      '23100412',
      '22412313',
      '13104232',
      '03041421',
      NULL,
      '33311430',
      '14113032',
      '42410032',
      '40022034',
      '30420101',
      '22232444',
      '12323112',
      NULL,
      NULL,
      NULL,
      NULL,
      '00404112',
      NULL,
      '04224403',
      NULL,
      '43231321',
      NULL,
      '43143344',
      '30014411',
      '44000240',
      NULL,
      '33204302',
      NULL,
      '13420330',
      '01333210',
      '04032001',
      NULL,
      NULL,
      '14323211',
      '14414140',
      '03101020',
      NULL,
      NULL,
      '312',
      '23',
      18.738372,
      NULL,
      '4442231',
      1,
      5.456547,
      2,
      NULL,
      NULL,
      1,
      ' 7-11-1987',
      ' 9-26-1989',
      NULL,
      138.944095,
      5,
      7.081986,
      NULL,
      5,
      1.457240,
      NULL,
      NULL,
      5.830566,
      NULL,
      3.587863,
      18,
      8.832855,
      1,
      5.163456,
      5,
      8.480140,
      NULL,
      NULL,
      33.393790,
      2.721535,
      46,
      11.703853,
      NULL,
      12.723784,
      NULL,
      32,
      NULL,
      43,
      39,
      '11-20-2000',
      18.118778,
      13.957306,
      22.213608,
      19,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      33.885473,
      5.088153,
      3.407141,
      3.625527,
      0.926305,
      '11- 7-1984',
      1.646529,
      0,
      104,
      5.010737,
      4,
      NULL,
      0.594157,
      3,
      2,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1979',
      31.642577,
      NULL,
      NULL,
      38,
      NULL,
      19.866936,
      75,
      46.252689,
      4,
      68,
      35.145739,
      18,
      '10-24-1983',
      5,
      1.852988,
      2.398796,
      7,
      20.465111,
      2,
      2,
      ' 8-16-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.216594,
      13,
      ' 2-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.107768,
      '10-11-2002',
      16,
      NULL,
      0,
      ' 6-17-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.481647,
      NULL,
      ' 1- 5-1988',
      NULL,
      0,
      154.212627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


