set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '1',
      '2',
      '0',
      NULL,
      '1',
      '4',
      '4',
      '1',
      '4',
      '3',
      NULL,
      '0',
      '1',
      '2',
      NULL,
      '3',
      '1',
      '0',
      NULL,
      '4',
      '0',
      '',
      NULL,
      '',
      '4',
      '0',
      '2',
      '2',
      '3',
      NULL,
      NULL,
      '2',
      '3',
      '4',
      '0',
      '1',
      '2',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '120',
      '33420031',
      43.850010,
      57.453013,
      '4202413',
      NULL,
      94,
      1,
      0,
      '140122',
      4,
      ' 0-11-1975',
      ' 1- 1-1979',
      17.936826,
      64.898978,
      15.156402,
      8,
      21,
      10.412273,
      2,
      NULL,
      7.674289,
      NULL,
      0.966298,
      6,
      NULL,
      2,
      0,
      5.761722,
      NULL,
      8,
      NULL,
      2.995670,
      4,
      2,
      66.646255,
      8,
      NULL,
      48,
      NULL,
      25.398563,
      82,
      NULL,
      NULL,
      '10- 8-1984',
      0.847051,
      9,
      21.363704,
      11.864335,
      58,
      65,
      ' 1-25-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.939978,
      22.855890,
      11,
      11.242181,
      1.739483,
      ' 0-23-1985',
      0.479464,
      0.298911,
      145,
      0,
      NULL,
      22.632195,
      1,
      2,
      10.401263,
      NULL,
      NULL,
      NULL,
      '11- 0-1995',
      1,
      29.032330,
      28.835862,
      4.772026,
      39,
      NULL,
      10,
      47.318727,
      27.429898,
      33.649788,
      23,
      27.683838,
      ' 2- 2-1989',
      0.070568,
      1.352199,
      3.372677,
      8,
      NULL,
      NULL,
      1.203232,
      ' 1- 0-2003',
      1,
      0.558476,
      NULL,
      NULL,
      5,
      2.413763,
      NULL,
      2,
      NULL,
      NULL,
      1.271750,
      0,
      3,
      3.032669,
      1.918714,
      0.474429,
      10,
      3,
      NULL,
      0.843696,
      0,
      ' 1- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      23.503494,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11- 9-1975',
      10,
      '10-29-2000',
      NULL,
      3.846687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.871030,
      ' 7-26-1996',
      39,
      2.827047,
      3,
      ' 9- 6-1986',
      NULL,
      NULL,
      NULL,
      2.764706,
      35.740580,
      1,
      58.822946,
      NULL,
      47.981948,
      0.991966,
      99,
      ' 9-24-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


