set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9757847';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '2',
      NULL,
      '0',
      '4',
      '2',
      '4',
      '3',
      '2',
      '3',
      NULL,
      '0',
      '1',
      '0',
      NULL,
      '4',
      '4',
      '2',
      NULL,
      '2',
      '3',
      '3',
      NULL,
      '',
      '3',
      '',
      '2',
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      '',
      '4',
      '4',
      '2',
      '3',
      '4',
      '3',
      '4',
      '4',
      '2',
      '2',
      '4',
      '002',
      '34422430',
      48,
      20,
      '2001143',
      0.499601,
      0.288549,
      2,
      NULL,
      '400242',
      1,
      NULL,
      NULL,
      52.699430,
      NULL,
      48.163399,
      0.519078,
      12.082366,
      4.915565,
      48.639975,
      27,
      2.776006,
      14.710140,
      12.069555,
      5,
      3,
      19.204683,
      15,
      NULL,
      4.460894,
      31,
      NULL,
      12.780339,
      23.315522,
      24,
      76.569196,
      14,
      0,
      68,
      6.552552,
      127.595109,
      187.770366,
      NULL,
      NULL,
      NULL,
      10,
      72.021335,
      NULL,
      40.181752,
      140,
      229.512915,
      ' 2-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      19,
      14,
      0,
      12.191024,
      10.100457,
      ' 5-22-1989',
      NULL,
      1,
      95.154135,
      0.430739,
      0.366118,
      49.203901,
      NULL,
      1.705255,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 1-1989',
      82,
      65.102821,
      30,
      103.815569,
      56,
      108,
      19,
      19.258997,
      NULL,
      48,
      NULL,
      12.707843,
      ' 6-10-1988',
      25,
      20.374242,
      7.360527,
      37.606186,
      29,
      NULL,
      3.036942,
      ' 2-27-1993',
      27.139823,
      8,
      ' 8-19-1995',
      10,
      13,
      23.655498,
      4,
      10,
      NULL,
      0.676339,
      2.899113,
      1.299126,
      118.026383,
      2.956106,
      2,
      20,
      12,
      1,
      0,
      NULL,
      NULL,
      ' 6- 8-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      22.308395,
      '11-22-1989',
      33.307469,
      NULL,
      NULL,
      7.430802,
      ' 3-22-1977',
      7.062987,
      10.030094,
      ' 9-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.581612,
      '11- 1-1985',
      NULL,
      56.923090,
      22.047588,
      ' 9- 4-1974',
      4,
      NULL,
      ' 8- 5-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


