set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0440',
      NULL,
      '12243211',
      '00304121',
      '13401420',
      NULL,
      '23030032',
      '42310013',
      NULL,
      NULL,
      '33123220',
      '24214301',
      '21314101',
      '34400443',
      '20122110',
      '32200342',
      '43240330',
      '34200231',
      '31322101',
      '12201234',
      '44414234',
      NULL,
      '31010121',
      '12402143',
      '00032114',
      '21424303',
      NULL,
      '20330331',
      '30320040',
      NULL,
      NULL,
      '21133200',
      '11332202',
      '31334024',
      '43224110',
      NULL,
      '34341143',
      NULL,
      NULL,
      '32440321',
      '12030131',
      '20114244',
      NULL,
      '00110041',
      '44213330',
      '232',
      '32',
      NULL,
      NULL,
      '4141131',
      NULL,
      1,
      NULL,
      NULL,
      '141200',
      NULL,
      NULL,
      ' 6-29-1974',
      18,
      NULL,
      26.343760,
      10,
      28,
      8.182328,
      28,
      10.998247,
      24,
      21.187909,
      32,
      8,
      NULL,
      5.803274,
      27,
      25.864604,
      10,
      0.115396,
      22,
      NULL,
      NULL,
      30,
      NULL,
      13,
      1,
      NULL,
      66,
      31,
      121.073981,
      1.316403,
      189.734930,
      NULL,
      8.007057,
      39,
      21,
      NULL,
      93,
      65.878160,
      ' 4-19-1993',
      0,
      1.002463,
      1,
      NULL,
      NULL,
      NULL,
      2.480524,
      0.373255,
      NULL,
      0.191716,
      0.149211,
      1,
      0,
      1.213311,
      0,
      1.154768,
      1,
      1.624330,
      0,
      1.707316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.720556,
      1,
      18,
      12.327333,
      NULL,
      6.998720,
      ' 8-23-1975',
      1,
      4,
      41,
      0.863354,
      NULL,
      32,
      1.815598,
      6,
      56,
      NULL,
      NULL,
      NULL,
      '10- 0-1977',
      94.628530,
      NULL,
      28,
      18,
      NULL,
      NULL,
      73.787758,
      NULL,
      74,
      65.842164,
      60.302661,
      39.424885,
      ' 8- 1-1987',
      12,
      12.033797,
      NULL,
      NULL,
      2.901846,
      147,
      3.930928,
      '10- 5-2003',
      15.109360,
      NULL,
      ' 5-15-1988',
      2,
      9.253292,
      14,
      10,
      19,
      2.908209,
      1.308254,
      16.871126,
      1,
      11.519287,
      1.036528,
      1.061071,
      6,
      7,
      NULL,
      4.403632,
      NULL,
      0.734974,
      ' 7-19-1974',
      0,
      NULL,
      0.295110,
      ' 2-23-1991',
      93.694575,
      17.793992,
      ' 1- 8-1978',
      NULL,
      NULL,
      NULL,
      55,
      ' 0- 4-1985',
      13.474283,
      ' 4-15-1988',
      10,
      15,
      ' 4-27-1986',
      51,
      8,
      ' 3-24-1997',
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      25.259328,
      NULL,
      25.034468,
      15,
      20,
      NULL,
      NULL,
      NULL,
      '11-24-1979',
      9.644621,
      25.573646,
      21.207472,
      0.064688,
      ' 5-11-2001',
      37,
      4,
      7,
      ' 2-16-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880724);
commit;
end;
/


