set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322',
      NULL,
      '22403430',
      '44030032',
      '11433200',
      '33101034',
      '14404044',
      '00344201',
      '20110204',
      '13040242',
      NULL,
      '20120132',
      '10041312',
      '04133340',
      NULL,
      '40144013',
      NULL,
      '33442202',
      '33230104',
      '41123122',
      '30003412',
      NULL,
      '30001233',
      '04310102',
      '11302202',
      '31020103',
      NULL,
      '41110232',
      NULL,
      '10122000',
      '12042240',
      '24323143',
      '33202300',
      '31024322',
      NULL,
      '03340004',
      '34203003',
      NULL,
      '24003031',
      NULL,
      '43030421',
      '33002434',
      '22243322',
      '22110313',
      NULL,
      '234',
      '10',
      12.479962,
      NULL,
      '1414112',
      3.379815,
      17.251588,
      3,
      NULL,
      '124440',
      NULL,
      ' 4-20-1994',
      ' 9-18-1990',
      NULL,
      77.021521,
      NULL,
      10,
      NULL,
      17,
      NULL,
      21.611542,
      4.083025,
      12.604178,
      3,
      1,
      NULL,
      6,
      NULL,
      24.882457,
      NULL,
      14.721175,
      59,
      16.609271,
      NULL,
      NULL,
      79,
      NULL,
      1,
      85,
      72,
      7,
      NULL,
      NULL,
      NULL,
      ' 4-16-1999',
      NULL,
      NULL,
      NULL,
      1,
      79,
      90.680517,
      ' 8- 5-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.203942,
      0,
      NULL,
      16,
      6,
      ' 7- 5-1984',
      NULL,
      0.930120,
      8,
      NULL,
      3.635120,
      79.128264,
      NULL,
      4,
      70,
      NULL,
      NULL,
      NULL,
      ' 0-12-1985',
      1,
      43.731919,
      2,
      43.351371,
      NULL,
      7,
      7,
      59,
      61.054527,
      NULL,
      9,
      71,
      ' 2-27-1998',
      25,
      27,
      9,
      23,
      25.806427,
      34,
      5,
      ' 0-25-1983',
      NULL,
      4.694170,
      NULL,
      11.746344,
      4,
      3,
      NULL,
      21.709094,
      NULL,
      0,
      19.248864,
      0.868399,
      107,
      6.778299,
      0,
      6,
      7.177295,
      2,
      0.420074,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      153,
      8.231305,
      ' 8- 2-1981',
      NULL,
      NULL,
      NULL,
      2.297352,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      71,
      29,
      ' 9-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      ' 5-14-1989',
      29,
      27,
      NULL,
      ' 1-23-1998',
      0,
      49.339159,
      ' 7- 5-1989',
      3,
      NULL,
      22.825181,
      32,
      ' 6-17-1988',
      8.423944,
      1,
      14,
      '10-13-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


