set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      '2',
      '2',
      '1',
      '3',
      '1',
      '4',
      '1',
      '1',
      '0',
      '1',
      '4',
      '2',
      '4',
      NULL,
      '1',
      '4',
      '1',
      '2',
      '1',
      '2',
      NULL,
      '',
      '1',
      NULL,
      '3',
      '3',
      '3',
      '4',
      '2',
      '',
      NULL,
      '0',
      '2',
      '0',
      NULL,
      NULL,
      '2',
      '2',
      '3',
      '4',
      '4',
      '2',
      '200',
      '23103331',
      52.869923,
      NULL,
      '2140041',
      3,
      133,
      NULL,
      1,
      NULL,
      3,
      ' 6-29-1991',
      ' 8-12-1986',
      3.398926,
      NULL,
      32.600649,
      21.366901,
      16,
      16,
      NULL,
      20,
      30,
      NULL,
      0.364374,
      2,
      30,
      NULL,
      NULL,
      2,
      NULL,
      13.715398,
      NULL,
      26.010095,
      NULL,
      NULL,
      2.286190,
      1,
      NULL,
      NULL,
      12.593215,
      85.786742,
      NULL,
      85,
      NULL,
      ' 8- 9-1979',
      26.591168,
      8.599136,
      4.050901,
      NULL,
      NULL,
      114.270926,
      ' 6-16-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      11,
      NULL,
      11,
      NULL,
      ' 5-13-1977',
      0.250348,
      1,
      139.835947,
      0,
      2.261713,
      86.646363,
      3.199957,
      5.590787,
      9,
      NULL,
      NULL,
      NULL,
      '11- 8-1985',
      NULL,
      99,
      94,
      11.242515,
      NULL,
      68,
      NULL,
      31.512861,
      95,
      67,
      69,
      1,
      ' 8- 8-1991',
      NULL,
      6,
      NULL,
      48.406571,
      19,
      107,
      11,
      NULL,
      35.875072,
      6.718805,
      ' 9- 1-1975',
      7,
      14.547911,
      7.146981,
      NULL,
      11.398710,
      2.549308,
      0.168024,
      7,
      NULL,
      51.007050,
      2.905931,
      1.746922,
      11.616712,
      0.171084,
      1,
      NULL,
      1,
      1,
      ' 8-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      15.551171,
      ' 5- 0-1981',
      NULL,
      NULL,
      NULL,
      5.157161,
      '11-24-2002',
      NULL,
      ' 6- 0-1977',
      NULL,
      6,
      ' 9-11-2001',
      35.120252,
      41,
      ' 9-29-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.401401,
      ' 0-10-1977',
      44.690881,
      5.486446,
      NULL,
      ' 5-11-1996',
      0,
      73,
      '10-29-1995',
      9,
      NULL,
      7.227656,
      6.233190,
      ' 1- 9-1983',
      39,
      NULL,
      NULL,
      ' 4- 9-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


