set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0201',
      '40240043',
      NULL,
      NULL,
      '00244213',
      '31413341',
      '41100212',
      '44002034',
      NULL,
      '24210233',
      NULL,
      '30113304',
      '10211402',
      NULL,
      NULL,
      '14232342',
      '20240040',
      '32344333',
      '34440210',
      '03201444',
      '23020440',
      '40122020',
      '43402100',
      NULL,
      '33233304',
      NULL,
      '02423430',
      '02440040',
      '33222401',
      '12021434',
      '34010241',
      NULL,
      NULL,
      '40232120',
      '13220243',
      '24100112',
      '34012414',
      '04430404',
      '33322033',
      NULL,
      '22202041',
      '02324420',
      '31014111',
      '34334144',
      '00134131',
      '421',
      '44',
      23.648142,
      10,
      '3313400',
      NULL,
      NULL,
      3,
      NULL,
      '041002',
      5.979100,
      ' 2-26-1979',
      ' 3-13-1976',
      89,
      111.457260,
      19,
      17.859650,
      16,
      7.698422,
      107.811211,
      6.614156,
      4,
      NULL,
      32.583544,
      23.609696,
      10.667519,
      2,
      28,
      13.332589,
      27,
      0.306794,
      NULL,
      0.405216,
      24.387497,
      13,
      84.873777,
      7.897071,
      1.340292,
      82.772633,
      151,
      NULL,
      89.562578,
      9,
      NULL,
      ' 1- 5-1976',
      42,
      65,
      36,
      11,
      81.628210,
      99,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91.210247,
      0.672214,
      NULL,
      8.813297,
      10,
      6.987836,
      ' 5-20-1995',
      1,
      0,
      80,
      0.206747,
      1.693613,
      83,
      1.610267,
      4,
      38.924703,
      NULL,
      NULL,
      NULL,
      ' 1-17-1984',
      38,
      NULL,
      28.697769,
      NULL,
      22.395936,
      40,
      6,
      NULL,
      42.295851,
      25,
      34,
      73.306062,
      ' 2-16-1989',
      7.827978,
      1.951995,
      22.891941,
      NULL,
      38,
      97.584604,
      4,
      '10-22-1979',
      4.668034,
      6.653474,
      ' 4-24-2002',
      6,
      11.593748,
      8,
      NULL,
      9.102941,
      1,
      5,
      1,
      0,
      24,
      3,
      NULL,
      2.872200,
      NULL,
      9.900826,
      1.701092,
      0,
      0.760101,
      ' 6-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      ' 1-26-1994',
      41,
      ' 2-19-1983',
      8.713539,
      8.931399,
      ' 3-17-1996',
      99.591235,
      58.443091,
      ' 1- 6-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      7,
      NULL,
      68,
      9,
      NULL,
      NULL,
      0.064594,
      15,
      ' 7-26-1977',
      6,
      61.467932,
      16.447591,
      NULL,
      ' 8-12-1992',
      71,
      1,
      66.516760,
      ' 7- 4-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


