set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '2',
      '2',
      NULL,
      '4',
      '2',
      '0',
      '2',
      '2',
      NULL,
      NULL,
      '0',
      '4',
      '0',
      '3',
      '3',
      '0',
      '0',
      '0',
      NULL,
      '1',
      '2',
      '0',
      NULL,
      NULL,
      '',
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '0',
      '3',
      NULL,
      '1',
      '4',
      '4',
      '3',
      '3',
      NULL,
      '4',
      '3',
      '343',
      '34220314',
      NULL,
      NULL,
      '0340343',
      3.101158,
      3.677350,
      1,
      NULL,
      NULL,
      4,
      ' 3- 1-2001',
      ' 2-15-1998',
      71.425862,
      250,
      NULL,
      5.095228,
      3.011666,
      8,
      NULL,
      6.955080,
      NULL,
      7.010973,
      29.908988,
      14.064488,
      NULL,
      1.348912,
      8.387850,
      10.609646,
      14.073391,
      NULL,
      NULL,
      19.281203,
      40.824260,
      4.983014,
      18,
      11.629714,
      0,
      83.408957,
      NULL,
      55,
      NULL,
      167,
      164.987811,
      ' 9- 9-1989',
      48,
      40.780698,
      14,
      13.413981,
      10,
      184,
      ' 1-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      1.841061,
      7,
      2.315745,
      6,
      ' 7- 1-2002',
      NULL,
      0.759168,
      162.377646,
      NULL,
      0.206606,
      30,
      1,
      0.002332,
      20.704508,
      NULL,
      NULL,
      NULL,
      ' 1-22-1990',
      73.470774,
      27.732553,
      74,
      NULL,
      95,
      50,
      31.566507,
      18,
      NULL,
      NULL,
      67,
      38,
      ' 9- 4-1982',
      25.858669,
      16.417308,
      NULL,
      NULL,
      36.643742,
      180.061304,
      NULL,
      NULL,
      4.340046,
      13,
      '10-14-1977',
      NULL,
      0.165766,
      9,
      14.772533,
      NULL,
      NULL,
      1.146943,
      9,
      1,
      12,
      2,
      1.804550,
      2,
      12.368328,
      2.917974,
      5.896255,
      1,
      NULL,
      ' 6-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      81.365935,
      36,
      ' 1- 2-2001',
      NULL,
      NULL,
      NULL,
      5,
      ' 7- 4-1987',
      NULL,
      ' 2-15-1986',
      7.554422,
      9,
      ' 5- 8-2003',
      91.817010,
      100.287831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.419824,
      ' 0-16-1979',
      NULL,
      2,
      12.243912,
      ' 4- 1-1974',
      1.765825,
      43,
      ' 6-22-1991',
      11,
      67.761217,
      5,
      33,
      ' 3-28-2003',
      62.400035,
      1,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


