set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '4',
      '3',
      NULL,
      '0',
      NULL,
      '1',
      '0',
      '1',
      '2',
      '3',
      '2',
      NULL,
      '1',
      '1',
      '4',
      '2',
      '0',
      '3',
      NULL,
      '2',
      NULL,
      '2',
      '',
      '3',
      NULL,
      NULL,
      '2',
      '2',
      '0',
      '3',
      '',
      '',
      '4',
      NULL,
      '2',
      '4',
      NULL,
      '4',
      '2',
      '4',
      '1',
      NULL,
      '0',
      '124',
      '41431313',
      NULL,
      29,
      '3200133',
      1,
      47.366695,
      2,
      0,
      '021203',
      NULL,
      ' 2- 7-1994',
      ' 1-28-1980',
      180.850710,
      100,
      36.539243,
      NULL,
      21.753201,
      1,
      73,
      19,
      5.360147,
      13,
      48,
      19.500676,
      NULL,
      4,
      9,
      8,
      20.996454,
      19.207663,
      21,
      NULL,
      27.786656,
      12,
      13,
      11.581983,
      1,
      105,
      151,
      64.379061,
      83.142730,
      NULL,
      98.562507,
      ' 1-19-1995',
      49,
      42,
      NULL,
      23.680331,
      NULL,
      199,
      ' 7-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      87,
      19.488611,
      NULL,
      9,
      NULL,
      1,
      ' 2- 3-1982',
      1,
      0.800283,
      20,
      2,
      0.041216,
      77.433218,
      1.515723,
      0.100750,
      39,
      NULL,
      NULL,
      NULL,
      ' 5- 4-1997',
      64,
      5,
      NULL,
      68,
      76.612083,
      96,
      81.266024,
      83.223171,
      88.600248,
      76,
      91.207313,
      79.970037,
      ' 4- 3-2002',
      10.534814,
      NULL,
      6,
      NULL,
      30.513507,
      NULL,
      NULL,
      ' 2-17-1988',
      12.062068,
      4,
      NULL,
      9.397138,
      4,
      10.981306,
      NULL,
      9.502755,
      9.580872,
      0,
      11.192311,
      1,
      62.339108,
      NULL,
      1.537828,
      0,
      NULL,
      13,
      3.845444,
      4,
      2,
      ' 4-16-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      53.017649,
      5.006381,
      ' 7-22-1999',
      NULL,
      NULL,
      NULL,
      12,
      ' 1-28-1990',
      12.850648,
      ' 1- 4-1976',
      9.777904,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      10.900339,
      NULL,
      NULL,
      3.627337,
      13,
      ' 4- 4-1986',
      NULL,
      130,
      ' 4-13-1989',
      12,
      50,
      NULL,
      NULL,
      ' 3-22-1992',
      14,
      1,
      23.483418,
      ' 1-12-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


