set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9420554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3013',
      '21301340',
      '42004342',
      '22120034',
      '12400203',
      '23422240',
      NULL,
      '33413102',
      NULL,
      NULL,
      '00241113',
      NULL,
      '01403334',
      '10243310',
      '20332311',
      '03314033',
      '04402131',
      NULL,
      '04111143',
      '32144200',
      '20231433',
      '40222021',
      '34401410',
      '44304022',
      '12203133',
      NULL,
      '04414134',
      '00224233',
      '32044303',
      '34142022',
      '44234232',
      '04422100',
      '34430042',
      '10013303',
      '32411143',
      '31341042',
      '34413331',
      NULL,
      '23020413',
      '14204244',
      '00104224',
      '44213131',
      NULL,
      '34431234',
      '43221300',
      '323',
      NULL,
      NULL,
      NULL,
      NULL,
      3.349339,
      NULL,
      2,
      NULL,
      '431424',
      5.525266,
      '10- 8-1983',
      ' 7-18-2002',
      110,
      NULL,
      NULL,
      1,
      0.235738,
      9.409302,
      16.427272,
      5.679108,
      20,
      16,
      14,
      0.200316,
      3.196781,
      3,
      9.490604,
      9,
      NULL,
      11.473588,
      14.560881,
      5,
      0.196757,
      0,
      9.182159,
      3.305406,
      1.606208,
      26,
      NULL,
      20.960987,
      56,
      86,
      107.002048,
      ' 1- 8-1977',
      38,
      15,
      13.404031,
      13.457718,
      112.078245,
      NULL,
      ' 4- 6-2000',
      2,
      NULL,
      NULL,
      2.502007,
      NULL,
      NULL,
      0,
      3.388342,
      1.336656,
      1,
      0.349504,
      1.197706,
      0.017106,
      3,
      NULL,
      NULL,
      5,
      0.569762,
      1.112828,
      4.449136,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-29-1995',
      47,
      21.400401,
      NULL,
      1.411518,
      14,
      1.475613,
      ' 9-11-1987',
      0.238955,
      6,
      37.894805,
      0,
      NULL,
      38,
      5,
      6.942598,
      11.235542,
      NULL,
      NULL,
      NULL,
      ' 4-25-1981',
      36,
      36,
      17,
      16.850697,
      55.642766,
      NULL,
      NULL,
      43,
      75,
      NULL,
      53.020843,
      76,
      NULL,
      5,
      4,
      4.445109,
      NULL,
      NULL,
      14.896727,
      NULL,
      ' 0- 8-1974',
      16,
      5.029457,
      ' 5- 7-1998',
      2,
      NULL,
      1.745043,
      NULL,
      5,
      5,
      1,
      0,
      0.710859,
      5.655593,
      NULL,
      1.548050,
      1.861817,
      10.927410,
      NULL,
      12.425872,
      1.368457,
      5,
      ' 7-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3.268320,
      NULL,
      44,
      ' 2-22-1983',
      NULL,
      5.770623,
      ' 1-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      7.724790,
      '11-10-1985',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.527055,
      NULL,
      20,
      NULL,
      1.740351,
      ' 2-12-1993',
      0.599132,
      210,
      ' 3- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


