set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1123',
      '32002443',
      '34420032',
      '24112414',
      '40333031',
      '04202031',
      '10103014',
      '33024003',
      NULL,
      '22014433',
      '42122204',
      '31101402',
      '13210341',
      '20130201',
      '11100224',
      '04443120',
      '44011421',
      '41223042',
      '22311241',
      '42241444',
      NULL,
      '23123432',
      '31020231',
      NULL,
      '14440432',
      '40310111',
      '23244433',
      '20122323',
      '02344100',
      '43422020',
      '13041312',
      '14234402',
      NULL,
      NULL,
      '01212201',
      '22132121',
      '33103204',
      '03401140',
      '44234200',
      '20320331',
      '13120433',
      '43344323',
      '03313420',
      '31024244',
      '13002442',
      '',
      '',
      NULL,
      NULL,
      '3240423',
      NULL,
      12,
      1,
      NULL,
      '330410',
      1,
      ' 0-13-1976',
      NULL,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      10.048958,
      NULL,
      18,
      57,
      198,
      ' 9-21-1984',
      3.418896,
      NULL,
      1.661999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939025,
      NULL,
      3.530700,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-28-1983',
      96,
      93,
      99.553725,
      65.264542,
      122,
      7,
      21.433079,
      13,
      9.095927,
      65,
      96.910076,
      95.975383,
      ' 8- 7-1994',
      16,
      NULL,
      3,
      NULL,
      14.162465,
      34,
      7.781471,
      ' 0-11-1993',
      0.578651,
      2,
      NULL,
      5.321415,
      11,
      10,
      7.872114,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994757,
      489.594289,
      ' 9-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      121,
      141,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651735,
      1,
      54,
      7,
      0,
      74.971950,
      2,
      NULL,
      NULL,
      2,
      4.532449,
      NULL,
      87,
      NULL,
      NULL,
      1,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      NULL,
      NULL,
      NULL,
      10.477043,
      0,
      0.489651,
      1,
      NULL,
      3,
      1.215627,
      NULL,
      1.657019,
      NULL,
      0.775402,
      54.232490,
      1,
      1.970995,
      60,
      18,
      NULL,
      19.787093,
      63,
      NULL,
      NULL,
      NULL,
      3.648602,
      5,
      1.813582,
      5,
      0,
      2.035790,
      0.735912,
      NULL,
      48.258675,
      NULL,
      NULL,
      NULL,
      ' 2- 7-1996',
      ' 8-22-1992',
      NULL,
      '10- 6-1978',
      NULL);
commit;
end;
/


