set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      '4',
      '3',
      '1',
      '2',
      '4',
      '0',
      '4',
      '4',
      '1',
      '4',
      '4',
      NULL,
      '4',
      '2',
      '2',
      '2',
      '0',
      '',
      '2',
      '',
      '1',
      '1',
      NULL,
      '1',
      '3',
      '',
      '',
      '1',
      '0',
      '4',
      NULL,
      '0',
      '0',
      '3',
      '0',
      '1',
      '2',
      NULL,
      '111',
      '41140034',
      1.423387,
      13,
      '1022002',
      3.788823,
      3.696446,
      NULL,
      NULL,
      '112204',
      NULL,
      ' 4- 8-1985',
      '10-18-1982',
      74.236244,
      125,
      NULL,
      13.538071,
      NULL,
      16,
      5.238125,
      NULL,
      6.813456,
      NULL,
      8,
      3,
      15.550933,
      14.148183,
      NULL,
      7.075514,
      2,
      7.344557,
      45,
      19,
      16,
      4,
      19,
      NULL,
      NULL,
      58.108849,
      55.857821,
      67.697401,
      197,
      172.687105,
      39,
      ' 1- 3-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      89,
      ' 8-24-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.904706,
      29,
      1.062279,
      7,
      22,
      2,
      ' 3- 2-2001',
      1,
      1,
      175,
      1,
      1,
      34,
      2.532518,
      1,
      44,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1983',
      NULL,
      40,
      3,
      NULL,
      73,
      2,
      NULL,
      93.474174,
      NULL,
      51.550496,
      32.430227,
      22,
      NULL,
      NULL,
      7,
      NULL,
      24,
      NULL,
      160,
      9,
      '10-16-1985',
      3.633023,
      NULL,
      NULL,
      9.590898,
      10,
      11,
      17.217433,
      2.848288,
      1.951652,
      1,
      10.910525,
      0.459080,
      7,
      1.184239,
      1,
      5.020447,
      5,
      2,
      4.032408,
      0,
      0,
      ' 0-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      113.726053,
      6,
      ' 4-10-1983',
      NULL,
      NULL,
      NULL,
      7.745197,
      ' 3-18-1977',
      11,
      ' 6- 8-2000',
      0.592822,
      7,
      NULL,
      91,
      60.967004,
      ' 8- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 7-22-1978',
      2,
      10,
      18.091537,
      NULL,
      4.959477,
      257.967063,
      ' 2-21-2000',
      5,
      24.622609,
      10.178681,
      44,
      NULL,
      7.614664,
      0,
      119,
      ' 6-22-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


