set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678994';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      '4',
      NULL,
      '2',
      NULL,
      '3',
      '4',
      '3',
      '0',
      '4',
      '0',
      '1',
      '3',
      '3',
      '4',
      '4',
      NULL,
      '3',
      '3',
      NULL,
      '2',
      '',
      '1',
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      NULL,
      '3',
      NULL,
      '2',
      '2',
      '2',
      '2',
      '4',
      '4',
      '2',
      '2',
      NULL,
      '300',
      '23014443',
      77,
      37,
      '1144420',
      3.492528,
      NULL,
      NULL,
      1,
      '222313',
      4,
      '10- 1-1982',
      '10-25-1997',
      NULL,
      33.691088,
      1,
      10,
      10,
      16.295367,
      55.889364,
      0,
      10.338570,
      0.077887,
      4.182966,
      11.485199,
      33.662211,
      12,
      26.706482,
      2,
      NULL,
      6.907922,
      9.972865,
      3,
      5,
      14,
      1.982316,
      1,
      1.126264,
      62.508759,
      93,
      12.582782,
      NULL,
      26.830233,
      2,
      NULL,
      4.345183,
      NULL,
      0,
      31,
      NULL,
      NULL,
      ' 5-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      18.522617,
      NULL,
      10,
      54,
      1.182440,
      NULL,
      1.486800,
      1,
      115.846137,
      0,
      0.760216,
      4,
      1.006882,
      0,
      45,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1996',
      NULL,
      28.416569,
      36,
      52.380280,
      40,
      13,
      18.230896,
      NULL,
      56,
      4,
      51,
      1,
      ' 6-23-1979',
      15.289737,
      1.913977,
      2,
      21,
      9.964609,
      NULL,
      5,
      ' 5- 8-1995',
      NULL,
      13,
      ' 1- 0-1991',
      2,
      NULL,
      3.396382,
      1,
      4.549215,
      4,
      0,
      4,
      0,
      23,
      5,
      1,
      7.317031,
      5,
      NULL,
      NULL,
      3.922395,
      NULL,
      ' 4-29-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.149178,
      ' 3- 2-2000',
      NULL,
      NULL,
      NULL,
      46.338495,
      ' 8-16-2001',
      NULL,
      ' 9-25-1993',
      18.493757,
      6.054988,
      ' 2-13-1991',
      46.880259,
      36,
      ' 3- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 3- 9-1998',
      NULL,
      15.288861,
      NULL,
      ' 8- 7-1991',
      NULL,
      51.468500,
      '10-24-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


