set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9328381';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4340',
      '24140103',
      '20001210',
      '22133141',
      '12142103',
      '13431230',
      '34102300',
      '10442304',
      '21134041',
      '14001421',
      '04413343',
      '42231131',
      '24410134',
      '12013310',
      '24103034',
      '30334144',
      NULL,
      '00320302',
      NULL,
      NULL,
      '41024240',
      '23303222',
      '04210440',
      NULL,
      NULL,
      NULL,
      '21010102',
      '24044400',
      NULL,
      '20244023',
      '30441344',
      '01234014',
      NULL,
      '42414244',
      '43030144',
      '31310411',
      NULL,
      '34102420',
      '34210201',
      NULL,
      '03423031',
      '44230242',
      '00340430',
      '42042330',
      NULL,
      '014',
      '13',
      NULL,
      NULL,
      '2334123',
      1.904752,
      1.001598,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1974',
      ' 8-10-1987',
      106.418487,
      NULL,
      9.137147,
      NULL,
      4,
      16,
      NULL,
      16,
      NULL,
      1.283352,
      1.224924,
      15,
      NULL,
      20.611769,
      1.119911,
      20,
      0.198698,
      2.483595,
      0,
      11,
      23.704998,
      15.887422,
      54,
      10,
      1,
      3,
      16,
      8,
      160.911648,
      NULL,
      192,
      ' 4-18-1985',
      25.255064,
      55,
      8.468376,
      21.135861,
      165,
      NULL,
      NULL,
      NULL,
      1.064937,
      NULL,
      1.079225,
      3,
      1,
      3,
      1,
      0,
      NULL,
      1.458973,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.245518,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      274,
      0,
      5.640929,
      222.692437,
      NULL,
      NULL,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      2.621059,
      33,
      34,
      65,
      33.089703,
      52.918191,
      39.910851,
      50.332461,
      65,
      NULL,
      48,
      ' 8-10-1975',
      21.629850,
      11,
      24.047364,
      5,
      31,
      NULL,
      5.141487,
      ' 7- 4-1987',
      NULL,
      25,
      ' 2-11-1980',
      4,
      17.799217,
      20,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      59,
      2,
      13.019086,
      23,
      NULL,
      4.768558,
      0.072660,
      1.002866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      1,
      ' 5-26-1987',
      NULL,
      NULL,
      NULL,
      51,
      '10- 7-2003',
      21.699886,
      ' 9- 6-1976',
      0,
      4.838526,
      ' 1-21-1996',
      47,
      94.983507,
      '11-19-1988',
      3.088790,
      1,
      ' 1-15-1991',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      11,
      ' 0- 8-1992',
      42,
      10,
      NULL,
      ' 7-20-1999',
      0.154690,
      0.658551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


