set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9001593';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1340',
      '32404102',
      '13410234',
      '30332304',
      '24030303',
      '04103444',
      '24203233',
      '22443211',
      '02142311',
      '03144004',
      NULL,
      NULL,
      '34333222',
      NULL,
      '41230111',
      '34124321',
      '20414241',
      '24022320',
      '42313223',
      '03024444',
      NULL,
      '33103104',
      '04242031',
      NULL,
      '04334122',
      '42100130',
      NULL,
      '20313021',
      '23023201',
      NULL,
      '40442442',
      '23103243',
      NULL,
      NULL,
      '02124230',
      '32100442',
      '23030143',
      '00034411',
      '03422034',
      '22202204',
      '21042011',
      '00432401',
      NULL,
      '30234010',
      '40333033',
      '',
      '',
      NULL,
      NULL,
      '3403110',
      1.251544,
      0,
      3,
      NULL,
      NULL,
      1,
      '10-29-2001',
      ' 4-14-1989',
      NULL,
      NULL,
      38,
      NULL,
      14,
      4,
      92.145784,
      14.513150,
      8,
      21,
      43,
      22.811877,
      5,
      NULL,
      21.665492,
      NULL,
      1,
      13,
      43,
      23,
      20,
      14.684663,
      13.085660,
      3.241086,
      NULL,
      83.559769,
      NULL,
      34,
      82,
      96.676430,
      34.760693,
      NULL,
      5.607014,
      3.610499,
      33.858783,
      20.188275,
      138,
      NULL,
      NULL,
      NULL,
      0.936804,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.001226,
      NULL,
      NULL,
      0.703379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      105.771639,
      18.656851,
      117,
      3,
      NULL,
      80.460822,
      35.388239,
      99.090540,
      NULL,
      NULL,
      16.314863,
      20,
      ' 4- 0-1994',
      NULL,
      0,
      NULL,
      15,
      20,
      1,
      0.613415,
      ' 4-11-2000',
      NULL,
      6.960760,
      ' 0-20-1992',
      7,
      11,
      7,
      6,
      0.889328,
      9.038901,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      7.790182,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.907565,
      NULL,
      NULL,
      0.756958,
      47,
      ' 4- 2-1986',
      5.778607,
      NULL,
      20.722837,
      27,
      ' 5-19-1998',
      0.068504,
      1.255706,
      155,
      ' 8- 9-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      50.612589,
      1,
      85.905851,
      NULL,
      57,
      11.468116,
      0,
      9,
      1.755789,
      NULL,
      24,
      NULL,
      0,
      25,
      0.575315,
      0,
      28.950175,
      1.261117,
      0.047682,
      51,
      NULL,
      3.448923,
      NULL,
      29.870075,
      8.056885,
      102.720251,
      1,
      63.113161,
      0.520322,
      NULL,
      1.753784,
      0,
      0,
      1.154895,
      NULL,
      86.824342,
      20,
      1,
      5,
      52.597465,
      1,
      0,
      17.090430,
      1,
      NULL,
      1,
      12,
      1.145540,
      17,
      0,
      36.257442,
      1.249936,
      NULL,
      83.984367,
      8.933242,
      NULL,
      20,
      37,
      NULL,
      19.364018,
      11.897320,
      NULL,
      2,
      0.879620,
      4,
      0.415175,
      0,
      0,
      1,
      98,
      ' 5-27-2002',
      ' 6- 0-1991',
      NULL,
      ' 4-29-2000',
      ' 7-22-1993',
      '11-21-1997',
      NULL,
      NULL);
commit;
end;
/


