set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9213653';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '0',
      NULL,
      '2',
      '3',
      '3',
      NULL,
      '4',
      NULL,
      '4',
      '1',
      '0',
      '3',
      NULL,
      '0',
      NULL,
      '4',
      NULL,
      '0',
      NULL,
      '1',
      '2',
      '1',
      '',
      '2',
      '',
      '4',
      '0',
      '0',
      '0',
      NULL,
      NULL,
      '',
      '2',
      '3',
      '1',
      '1',
      NULL,
      '3',
      NULL,
      '0',
      '0',
      '3',
      '2',
      NULL,
      '34',
      27.879078,
      19.511065,
      '0102011',
      3,
      1.211248,
      1,
      NULL,
      '241130',
      3,
      ' 2- 2-1992',
      NULL,
      NULL,
      138.403677,
      28,
      1.004352,
      12,
      2.211386,
      37.750351,
      23.610933,
      11,
      4,
      45.473070,
      4,
      13,
      29.354520,
      15,
      7.522985,
      9,
      21.645904,
      45.065519,
      6,
      53,
      16.990048,
      79.100674,
      8,
      0.585032,
      32,
      176.327428,
      16,
      176.442498,
      169,
      11,
      '11- 9-1988',
      9,
      NULL,
      13,
      18,
      23.536044,
      NULL,
      '10- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.856158,
      15.741577,
      0,
      NULL,
      2.774676,
      7.416160,
      '11-13-1975',
      0.351784,
      0,
      184,
      1.261943,
      5,
      150.756397,
      0.528676,
      0.906096,
      63,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1986',
      7,
      54,
      NULL,
      NULL,
      77,
      48,
      75.589655,
      42,
      80.159440,
      74,
      74.107471,
      30,
      '11-18-1985',
      3,
      1.969857,
      10,
      33,
      27.282059,
      71,
      NULL,
      ' 4-11-2003',
      22.437222,
      12,
      ' 1-11-1989',
      2,
      14,
      24.103131,
      16,
      10,
      10,
      0.031505,
      NULL,
      0.606022,
      10,
      1,
      NULL,
      6.027886,
      2.136311,
      0,
      1.795095,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.665099,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1997',
      38,
      '10-25-1992',
      17.095231,
      NULL,
      '11-13-1977',
      28,
      81,
      ' 3-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 1- 1-1998',
      67.905049,
      NULL,
      4.113533,
      ' 1-28-1993',
      1,
      37,
      ' 5-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


