set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3404',
      '02412340',
      '43410334',
      NULL,
      '40224334',
      NULL,
      '04130213',
      '23023320',
      '31200143',
      '13400341',
      '22432124',
      '11413024',
      '04142143',
      '24344243',
      '30214012',
      '31142014',
      '03220021',
      '43004114',
      '23331203',
      NULL,
      '20012221',
      '44414310',
      '23210032',
      NULL,
      '43022114',
      '44302241',
      '34201213',
      '31122001',
      '43304021',
      '11441302',
      '32330133',
      NULL,
      '30124000',
      '41344002',
      '30110403',
      '02220430',
      '30410430',
      NULL,
      '14323012',
      NULL,
      '10132301',
      '41310400',
      '12302323',
      '21010111',
      '24121344',
      '304',
      NULL,
      NULL,
      NULL,
      '0312433',
      1.260866,
      0,
      0,
      NULL,
      '430201',
      3.940199,
      ' 6-28-1979',
      ' 1-28-1984',
      NULL,
      NULL,
      9,
      10,
      4.548758,
      6,
      26.429860,
      12,
      NULL,
      NULL,
      21.942304,
      NULL,
      7.820777,
      6.764730,
      NULL,
      NULL,
      NULL,
      9.294574,
      25,
      10.708438,
      33,
      3,
      42,
      3,
      0,
      36,
      122.222182,
      NULL,
      126,
      70.882645,
      NULL,
      ' 3-23-1983',
      6,
      21,
      NULL,
      11,
      70.144297,
      66,
      '10-19-1981',
      0,
      1.530618,
      NULL,
      2,
      0,
      3.054008,
      NULL,
      2.351737,
      NULL,
      0,
      1,
      NULL,
      0.756105,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.080961,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-1975',
      57,
      NULL,
      12.752542,
      2,
      8.866779,
      NULL,
      NULL,
      NULL,
      NULL,
      197,
      0,
      1,
      1,
      0,
      0.495721,
      38,
      NULL,
      NULL,
      NULL,
      ' 7- 6-1976',
      47.331773,
      49,
      NULL,
      NULL,
      14.468742,
      85.268206,
      31,
      13,
      NULL,
      25,
      18.777946,
      6.122026,
      ' 7-24-1981',
      7,
      25,
      11.148856,
      59,
      NULL,
      NULL,
      11.091368,
      ' 6-22-1990',
      30.875757,
      NULL,
      ' 7-16-1975',
      4.268461,
      NULL,
      NULL,
      31,
      NULL,
      1.632228,
      NULL,
      8,
      0.466247,
      10.619896,
      1.990253,
      3,
      19.258230,
      15.637924,
      0,
      1.823011,
      0.247829,
      NULL,
      ' 6-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      33.615967,
      NULL,
      ' 4-16-1982',
      NULL,
      NULL,
      NULL,
      7.907575,
      NULL,
      34.237339,
      NULL,
      13.229996,
      15.702963,
      ' 3-23-1975',
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      ' 8- 0-1979',
      NULL,
      NULL,
      NULL,
      0,
      2,
      15,
      '10- 6-1975',
      7,
      12.571391,
      18.552273,
      ' 9-14-1990',
      NULL,
      NULL,
      '11- 4-1995',
      0.429902,
      160,
      NULL,
      86,
      ' 5- 8-1999',
      60.129834,
      0.299216,
      148.293072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


