set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41111342',
      '20103424',
      NULL,
      '30112214',
      '01312012',
      '01310214',
      '13103042',
      '24122202',
      '23320303',
      '42341133',
      '11243314',
      NULL,
      '32120232',
      '31442342',
      '24044420',
      '23331221',
      '01243020',
      '42233414',
      '20000133',
      '20324143',
      '31104001',
      NULL,
      '40311304',
      '30013100',
      NULL,
      NULL,
      '24340404',
      NULL,
      NULL,
      '44143311',
      '01331343',
      '22443010',
      '10120233',
      '31243321',
      NULL,
      '04302123',
      NULL,
      '01141420',
      NULL,
      '33431113',
      '01210441',
      '30012212',
      '30423122',
      '32112030',
      '021',
      '10',
      NULL,
      3.485090,
      '4204334',
      2.293827,
      NULL,
      2,
      NULL,
      '201220',
      4.990610,
      ' 3-18-2002',
      NULL,
      96,
      28,
      14,
      2,
      15,
      11.303320,
      2.801540,
      NULL,
      1.684523,
      0.440987,
      0,
      13,
      9.139602,
      NULL,
      6.901887,
      NULL,
      17.347547,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.248647,
      4,
      1.104382,
      14,
      26,
      NULL,
      NULL,
      58.964284,
      99,
      ' 0- 2-1992',
      34,
      NULL,
      6.771761,
      19,
      52,
      49,
      ' 5-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.551229,
      35,
      NULL,
      11,
      3,
      ' 1-12-1989',
      1,
      1,
      8,
      NULL,
      0,
      NULL,
      0.517073,
      0.831497,
      21,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1978',
      23,
      NULL,
      NULL,
      NULL,
      70,
      50.085856,
      42,
      5.851017,
      48,
      50,
      NULL,
      12.555142,
      ' 4- 1-2002',
      6,
      14.859645,
      6.142930,
      22.974683,
      7,
      43,
      5.710786,
      ' 1-18-2003',
      NULL,
      20.637992,
      ' 3- 1-1977',
      6,
      6.644715,
      NULL,
      29.760424,
      23,
      6.390286,
      0,
      4,
      1.674672,
      48.573907,
      0.545528,
      15,
      11,
      19,
      NULL,
      0.039951,
      1.033358,
      0.124674,
      ' 1-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      178.329456,
      10.595184,
      ' 4-17-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-22-1994',
      19.650572,
      ' 1- 1-1991',
      20,
      0.263979,
      ' 4-29-2002',
      81.534959,
      28,
      ' 8- 9-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.922017,
      NULL,
      NULL,
      NULL,
      12.354918,
      ' 3- 7-1977',
      1.540104,
      76,
      '10-28-1997',
      1.892282,
      3,
      NULL,
      8,
      ' 9- 8-1993',
      9.129551,
      0.981130,
      59.539333,
      '10-24-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


