set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '2',
      '1',
      '3',
      '2',
      '4',
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '1',
      '2',
      '3',
      '1',
      NULL,
      '0',
      NULL,
      '0',
      '3',
      '0',
      NULL,
      '2',
      NULL,
      '0',
      '',
      '0',
      '3',
      '4',
      '0',
      '4',
      '',
      '',
      NULL,
      '2',
      NULL,
      '2',
      '0',
      '2',
      '3',
      '2',
      '0',
      '1',
      '0',
      NULL,
      NULL,
      65.624210,
      26,
      '0141312',
      1.688591,
      53,
      NULL,
      NULL,
      '422104',
      4.337710,
      '10-18-1974',
      ' 8- 3-1988',
      95,
      257,
      NULL,
      3.027985,
      4.813237,
      10,
      37,
      10.457535,
      7.821983,
      4,
      14,
      11,
      8,
      3.913324,
      27,
      3,
      NULL,
      1,
      0,
      1,
      10,
      6,
      NULL,
      5,
      1,
      58,
      NULL,
      11,
      131.854065,
      7,
      57.463159,
      ' 7- 4-1976',
      30.865244,
      NULL,
      15.467900,
      NULL,
      42,
      NULL,
      ' 0-15-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.996281,
      NULL,
      66.554537,
      14,
      NULL,
      0,
      ' 9-10-1991',
      0.207429,
      0,
      86,
      NULL,
      1.890430,
      100,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1999',
      74.728934,
      90,
      3.246962,
      82.438218,
      8.113802,
      NULL,
      74.801689,
      10,
      NULL,
      NULL,
      30,
      NULL,
      ' 5- 3-1975',
      12.689072,
      20.065250,
      4.824869,
      NULL,
      36.147949,
      NULL,
      8.294943,
      '11- 6-1992',
      23.110197,
      3.893612,
      '11-16-1997',
      5,
      1,
      18.471763,
      7.197502,
      8.989020,
      4.629350,
      NULL,
      NULL,
      0.119612,
      NULL,
      0.370054,
      0.637138,
      NULL,
      7.275228,
      0,
      NULL,
      0.359114,
      0.328223,
      ' 8- 3-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      ' 9-11-1982',
      NULL,
      NULL,
      NULL,
      28.293821,
      '10-24-1984',
      17.344490,
      ' 3-13-1980',
      7,
      5,
      ' 0- 0-1976',
      57.827853,
      22.739018,
      ' 4-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      15.796544,
      '11- 7-1989',
      3,
      22.956194,
      3,
      ' 4-20-1985',
      NULL,
      122,
      NULL,
      0,
      48,
      11,
      47,
      ' 9-26-1999',
      66.619300,
      NULL,
      97.446854,
      '11-11-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


