set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '0',
      '2',
      '2',
      '3',
      '3',
      '0',
      '0',
      '4',
      '3',
      '2',
      '1',
      '1',
      NULL,
      '0',
      '3',
      '2',
      '1',
      NULL,
      NULL,
      '2',
      '4',
      '1',
      '',
      '4',
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      '4',
      '',
      NULL,
      '0',
      '2',
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2',
      '242',
      NULL,
      45,
      42,
      '1133120',
      2.563027,
      NULL,
      NULL,
      NULL,
      '112421',
      5,
      ' 6-16-1985',
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      1,
      51,
      NULL,
      7.680962,
      14,
      2,
      10.281605,
      NULL,
      NULL,
      0.695276,
      2,
      4.083392,
      9,
      10,
      17.586480,
      36.645535,
      11.289516,
      61.268341,
      NULL,
      1,
      42,
      110,
      57.956181,
      162,
      47.209284,
      12,
      ' 4-23-1974',
      NULL,
      5.681438,
      16.265778,
      17,
      9,
      195.811610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.862086,
      15,
      10,
      8.604790,
      15,
      10,
      ' 4-16-1981',
      0.416367,
      0,
      NULL,
      NULL,
      1,
      13.374120,
      NULL,
      0.457611,
      37.867685,
      NULL,
      NULL,
      NULL,
      NULL,
      48.645121,
      16,
      15.253450,
      42.881537,
      6,
      37,
      6,
      28,
      66,
      3.729064,
      25,
      18,
      NULL,
      22.930941,
      5.876208,
      14,
      2,
      1.174562,
      7,
      7,
      ' 9- 3-1988',
      20.088547,
      9,
      ' 9-10-1975',
      2,
      NULL,
      9.842268,
      2,
      2.070501,
      3,
      0,
      4.321359,
      NULL,
      22.810746,
      3,
      1.028727,
      10,
      NULL,
      6.608877,
      0.966678,
      0.499376,
      0,
      '11-22-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      46.781934,
      3,
      ' 2- 4-1976',
      NULL,
      NULL,
      NULL,
      20.829153,
      NULL,
      NULL,
      ' 9-15-1984',
      7,
      9.108550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.103610,
      '11-29-2002',
      41,
      17.931156,
      19,
      ' 9- 8-1982',
      NULL,
      NULL,
      ' 7-10-1985',
      15,
      NULL,
      13.847149,
      38,
      ' 8-15-1989',
      53,
      0.668007,
      NULL,
      ' 7- 1-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


