set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      '1',
      '4',
      '0',
      NULL,
      '3',
      '3',
      NULL,
      '3',
      '1',
      '2',
      '2',
      '1',
      '2',
      NULL,
      '2',
      '4',
      '3',
      '0',
      '1',
      '0',
      '3',
      '',
      '0',
      '',
      '3',
      '2',
      '4',
      '3',
      '1',
      '',
      '',
      '4',
      NULL,
      '0',
      NULL,
      '1',
      '1',
      '4',
      '1',
      NULL,
      '2',
      NULL,
      '043',
      '04434444',
      NULL,
      87,
      '4000424',
      0.297815,
      2.489053,
      NULL,
      1,
      NULL,
      6,
      ' 6-27-1990',
      ' 1- 8-1987',
      NULL,
      71,
      29,
      NULL,
      31,
      7,
      19.118209,
      NULL,
      23.411119,
      2.104807,
      17.112897,
      3.249825,
      7,
      NULL,
      35.148893,
      7,
      NULL,
      31.764845,
      15,
      0,
      32.214789,
      9,
      9,
      NULL,
      1,
      17.512167,
      39,
      33,
      207,
      45,
      155.581385,
      ' 9-16-2003',
      33,
      22,
      17.030269,
      30,
      196.208773,
      153,
      ' 3-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      101,
      3.567767,
      8.539451,
      7.853049,
      3,
      8.907521,
      NULL,
      0,
      NULL,
      65,
      NULL,
      1.117558,
      3.409580,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-26-1977',
      2,
      NULL,
      96.343588,
      45,
      NULL,
      96.563643,
      55.816903,
      NULL,
      77.833999,
      50.005241,
      NULL,
      60,
      ' 2- 3-1980',
      NULL,
      9.436389,
      10.657574,
      NULL,
      NULL,
      NULL,
      2.890385,
      ' 6- 2-1974',
      2,
      NULL,
      ' 0- 4-1980',
      NULL,
      NULL,
      18.854719,
      24.610529,
      18.536722,
      NULL,
      0,
      5,
      1.100127,
      94.185712,
      1.888171,
      1,
      9.969574,
      9,
      1,
      0.517099,
      0,
      NULL,
      '11- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      129,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      38.721698,
      ' 5-10-1976',
      6.096960,
      ' 0-23-2001',
      10.777248,
      13,
      ' 1- 4-1984',
      32,
      25.677958,
      ' 3-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      37,
      ' 3-21-1985',
      NULL,
      NULL,
      ' 2- 1-1984',
      15.541932,
      NULL,
      3,
      56.502213,
      ' 4-21-1981',
      58.578003,
      0.054204,
      363,
      ' 7- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


