set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7303351';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2001',
      '42134224',
      '31012120',
      '03413041',
      '13043030',
      NULL,
      '22144234',
      '33034130',
      NULL,
      '43144431',
      NULL,
      '24100440',
      NULL,
      '44212314',
      '44333102',
      '24204324',
      '44041030',
      '13212433',
      '30403430',
      NULL,
      NULL,
      '24424204',
      '04103001',
      '33140231',
      '22121100',
      '41122034',
      '01332202',
      '01433303',
      '41112322',
      NULL,
      '23034220',
      '43234302',
      NULL,
      '44444321',
      '14202034',
      NULL,
      NULL,
      '32004230',
      '44221110',
      '40332113',
      '33423234',
      '20344433',
      '23002403',
      NULL,
      '12320024',
      '',
      '',
      NULL,
      NULL,
      '1342111',
      NULL,
      NULL,
      NULL,
      NULL,
      '142220',
      NULL,
      ' 3-16-1996',
      ' 7- 1-1981',
      5.800072,
      NULL,
      1,
      NULL,
      13.233625,
      0,
      82,
      3.601844,
      2.611700,
      3,
      33,
      9,
      NULL,
      10.831505,
      14,
      21,
      NULL,
      16,
      54,
      5,
      NULL,
      9,
      106.256350,
      12,
      NULL,
      97.027737,
      13,
      47,
      148.602943,
      1,
      100.981984,
      NULL,
      3.888386,
      7.704734,
      30.845945,
      22.706475,
      156,
      66,
      ' 6- 7-1992',
      0.898209,
      3.691946,
      0.335753,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375636,
      0.242334,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-1980',
      123.911342,
      NULL,
      119.357166,
      31.657063,
      32.295640,
      12,
      101,
      85.877472,
      88,
      44,
      NULL,
      85.542205,
      ' 8-22-1985',
      6.551634,
      4.324810,
      3,
      25,
      37.984048,
      12,
      2,
      ' 4-29-1986',
      13,
      12,
      ' 2-19-2001',
      1,
      NULL,
      12.942279,
      NULL,
      19,
      0,
      NULL,
      17,
      NULL,
      47,
      1.280310,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      15.581969,
      37,
      ' 8- 8-1988',
      1,
      NULL,
      '10-20-1976',
      12,
      NULL,
      NULL,
      29.938648,
      NULL,
      38.540259,
      0,
      NULL,
      ' 6-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      183.392775,
      1.877317,
      NULL,
      NULL,
      61.990232,
      31.077930,
      15,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      23.464322,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400396,
      14.920795,
      1.260994,
      5,
      71,
      NULL,
      18.049987,
      NULL,
      0,
      NULL,
      0.414578,
      0.224707,
      0.982367,
      0,
      1.887106,
      1.735577,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      2.032181,
      4,
      63,
      1,
      0,
      3.836445,
      29,
      0,
      NULL,
      1,
      NULL,
      0.052079,
      1,
      NULL,
      16.211765,
      0.806622,
      18,
      NULL,
      NULL,
      3.139361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1997',
      NULL,
      ' 9-18-1998',
      ' 1-11-1986',
      ' 4-23-1980',
      NULL,
      NULL,
      NULL);
commit;
end;
/


