set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8827858';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1033',
      '04414424',
      NULL,
      '12122021',
      '03101304',
      NULL,
      '01021212',
      '01001332',
      '32132410',
      '31011330',
      '33131330',
      '44203043',
      '01100220',
      '20431211',
      '44133113',
      '32200023',
      '42211211',
      '34020304',
      '42221444',
      '01301323',
      '31124001',
      '13241430',
      '32424111',
      '02144440',
      '02144134',
      '41240133',
      '11304434',
      NULL,
      '13043120',
      '23223233',
      '13121014',
      '33321102',
      '30124434',
      '22412220',
      '24102031',
      NULL,
      '24301102',
      NULL,
      '33143311',
      '40343132',
      '42442403',
      '03010003',
      '42423233',
      '20013403',
      '44203344',
      '033',
      '40',
      9,
      13.048337,
      '1333024',
      2.796096,
      NULL,
      2,
      NULL,
      '243302',
      0,
      '10-26-1987',
      ' 1-21-1988',
      24.592936,
      90.539202,
      38.723941,
      1.413469,
      NULL,
      24.560015,
      NULL,
      10,
      20,
      14,
      1,
      25.795215,
      20.344136,
      19.941795,
      6.256682,
      11.685520,
      21.501570,
      NULL,
      NULL,
      NULL,
      17.407988,
      5,
      40.883575,
      28.069813,
      NULL,
      70.674255,
      72,
      96.044221,
      211,
      NULL,
      104,
      ' 7-16-2002',
      61,
      47,
      15,
      25,
      NULL,
      59,
      '11-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      10,
      8.637671,
      0.802505,
      4,
      0,
      ' 1- 4-2002',
      0,
      0.380100,
      228.864222,
      0,
      1,
      103.252624,
      0,
      2,
      77.440895,
      NULL,
      NULL,
      NULL,
      ' 0-13-1996',
      104,
      105.467954,
      69.727371,
      41,
      NULL,
      32,
      29.134935,
      76.481955,
      11.336465,
      59,
      NULL,
      63,
      '11- 6-1989',
      16.433344,
      28.912961,
      0,
      NULL,
      17.080930,
      160.369976,
      7,
      ' 0-26-1991',
      8,
      31.257728,
      ' 6- 9-1979',
      13,
      6,
      25,
      26,
      19,
      10,
      1,
      13.422480,
      0,
      62.298366,
      2.338115,
      1.909874,
      NULL,
      4.779492,
      1.572997,
      NULL,
      1,
      NULL,
      ' 3- 5-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      153,
      3.959089,
      '11- 2-2002',
      NULL,
      NULL,
      NULL,
      39,
      '11-15-1978',
      21.851507,
      ' 1-24-1981',
      13.846315,
      6,
      ' 4-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.410481,
      ' 7-24-1977',
      15,
      NULL,
      40.691357,
      ' 3-28-1992',
      1.414662,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


