set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3370623';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      '4',
      '3',
      '2',
      '0',
      '2',
      '1',
      '0',
      '2',
      '4',
      '0',
      NULL,
      '2',
      '3',
      NULL,
      '0',
      '0',
      NULL,
      '',
      '4',
      '',
      '0',
      '1',
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3',
      '0',
      '0',
      '2',
      '4',
      '0',
      '0',
      NULL,
      '1',
      '4',
      '1',
      '011',
      '14111010',
      NULL,
      10.586083,
      '2221424',
      NULL,
      1.009457,
      0,
      1,
      '414031',
      4.916111,
      NULL,
      ' 3-11-1980',
      9.924088,
      80.490397,
      11,
      11,
      18,
      0.998597,
      27,
      16,
      26,
      12,
      NULL,
      18.299033,
      NULL,
      9,
      4.969270,
      2,
      5,
      18.434640,
      38.223509,
      NULL,
      52,
      21,
      17.695248,
      17.185413,
      NULL,
      11,
      102.490429,
      58.476523,
      162.992024,
      148.563030,
      47.790444,
      ' 3-29-1985',
      34.793136,
      NULL,
      35,
      9.361303,
      NULL,
      16.409810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      90.703862,
      1.893897,
      NULL,
      3.434216,
      NULL,
      5.984591,
      ' 3-10-1985',
      1,
      1.325186,
      131,
      NULL,
      NULL,
      90,
      2.247500,
      3,
      105.163538,
      NULL,
      NULL,
      NULL,
      ' 8-10-1997',
      65,
      2.687941,
      81.004239,
      22.536877,
      NULL,
      NULL,
      76.492801,
      NULL,
      70,
      79.261312,
      NULL,
      8.206863,
      NULL,
      22,
      NULL,
      13.325026,
      10,
      33.005545,
      NULL,
      3,
      ' 4-11-1986',
      29.825860,
      NULL,
      ' 0-16-1998',
      3,
      15,
      8,
      NULL,
      NULL,
      0,
      1.812901,
      NULL,
      NULL,
      NULL,
      0.465159,
      0,
      1.702620,
      NULL,
      0,
      0,
      1.566357,
      1,
      ' 9-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      197.838644,
      0.372170,
      '10-17-2002',
      NULL,
      NULL,
      NULL,
      44.218566,
      ' 5-22-2001',
      14,
      ' 2-21-1980',
      14.153470,
      20.418857,
      ' 9-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 7-10-1988',
      5,
      27.819146,
      47.479230,
      ' 6-19-1974',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


