set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3404',
      '24301014',
      '44344403',
      '43330323',
      NULL,
      NULL,
      '04113332',
      '13200111',
      '14020442',
      '04413234',
      '01424021',
      '21133314',
      '01122004',
      '21313031',
      NULL,
      '20124333',
      '21332000',
      '14230112',
      NULL,
      '21440100',
      '23443311',
      '31314333',
      '13014231',
      '14123334',
      NULL,
      '24222220',
      '21023302',
      '13414032',
      '03234022',
      '41111243',
      '42314200',
      '32203221',
      '42323423',
      NULL,
      '32443334',
      '21133341',
      '14113420',
      '22301422',
      '01033131',
      NULL,
      NULL,
      '30331213',
      NULL,
      '42244402',
      '21241221',
      '042',
      '14',
      3.485830,
      7,
      '3033220',
      0.763856,
      1.909249,
      3,
      NULL,
      NULL,
      0,
      '10-21-1999',
      ' 5-28-1998',
      65,
      97.383917,
      5,
      6.375333,
      NULL,
      14.853840,
      9.146998,
      5.188180,
      11,
      NULL,
      8.727441,
      7.718019,
      9.182710,
      15,
      NULL,
      8.353001,
      5.329257,
      0.923352,
      13.939430,
      0.588555,
      6,
      4.814169,
      46,
      10,
      1.304450,
      NULL,
      141.463702,
      48,
      92,
      35.231027,
      145,
      ' 5-16-1985',
      10.220999,
      4,
      28.031112,
      NULL,
      22.365841,
      131.600139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.369049,
      12.574602,
      21.769132,
      10,
      21,
      5.596959,
      ' 1- 0-2003',
      0,
      2.611179,
      180,
      1.393560,
      3.937088,
      17.461652,
      0.168847,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1993',
      52,
      0.375245,
      13,
      77.163977,
      NULL,
      49,
      NULL,
      38.061834,
      74,
      19.965022,
      6.088879,
      5.151664,
      '10-19-1978',
      5.592292,
      NULL,
      21.511556,
      44.107995,
      56,
      12.594021,
      0,
      ' 2-25-1978',
      10,
      12.227200,
      ' 0-13-1974',
      4,
      3,
      0.982161,
      20,
      13,
      0,
      1,
      10,
      0.450293,
      50,
      0.822445,
      4.174427,
      7.004116,
      21.938880,
      1,
      NULL,
      5,
      NULL,
      ' 6-26-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      112.021256,
      0.471927,
      ' 8-16-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1980',
      NULL,
      ' 7-20-1976',
      NULL,
      NULL,
      ' 0-17-1994',
      NULL,
      2.408935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      10.936532,
      '10- 1-1993',
      37,
      6,
      2.346343,
      ' 6-27-1997',
      0.409114,
      NULL,
      ' 3-16-1986',
      0.810472,
      NULL,
      4.041055,
      NULL,
      NULL,
      NULL,
      0,
      86,
      ' 9-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


