set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '4',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '4',
      '1',
      '3',
      '1',
      '3',
      '2',
      '3',
      '1',
      '1',
      NULL,
      '4',
      NULL,
      '4',
      '0',
      '4',
      '1',
      '',
      NULL,
      '',
      '0',
      '1',
      '0',
      '4',
      NULL,
      '',
      '',
      '1',
      '2',
      '0',
      '3',
      '3',
      '1',
      '4',
      '0',
      '1',
      '0',
      '3',
      '433',
      '01234241',
      NULL,
      NULL,
      '4403310',
      NULL,
      64.363080,
      3,
      1,
      '042303',
      2.701623,
      ' 0-23-1975',
      ' 5- 1-1977',
      NULL,
      NULL,
      12,
      11,
      1.968054,
      7,
      32,
      6.938966,
      8,
      4.938137,
      1.351549,
      7,
      1.361233,
      1.976319,
      10.879544,
      9.309699,
      10.602929,
      NULL,
      2,
      3,
      37.731430,
      7,
      23.369163,
      11,
      0,
      29,
      140,
      42.661398,
      92,
      44,
      148.145988,
      NULL,
      NULL,
      12.616991,
      13.097965,
      NULL,
      79,
      137.913843,
      ' 8- 6-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314019,
      NULL,
      NULL,
      23,
      1,
      '10-10-1995',
      0,
      0.872823,
      175,
      4.922926,
      NULL,
      NULL,
      0.406926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-1985',
      74.671496,
      5.476622,
      NULL,
      104.997125,
      NULL,
      NULL,
      49.268110,
      90,
      59,
      4,
      117,
      14.263156,
      ' 3-25-1990',
      0,
      18.795079,
      14.854001,
      56.189098,
      37.452303,
      3.087249,
      11,
      NULL,
      5,
      NULL,
      NULL,
      5,
      12,
      15.444341,
      13.624777,
      19,
      8,
      1,
      17,
      NULL,
      66,
      14,
      NULL,
      13.596423,
      5,
      NULL,
      NULL,
      NULL,
      1,
      ' 5-18-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.644260,
      NULL,
      31,
      ' 1-15-1992',
      3.425040,
      5.948152,
      NULL,
      24.726451,
      9.560996,
      ' 5-16-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5,
      ' 0- 5-1988',
      18,
      8.544647,
      NULL,
      NULL,
      1.826815,
      70.824026,
      ' 6-20-1974',
      4,
      75,
      NULL,
      NULL,
      ' 8-25-1977',
      9,
      0.191535,
      15,
      ' 9- 8-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


