set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3111',
      '20120043',
      '33000010',
      '32210233',
      '20204010',
      '40311424',
      '23213334',
      '03103310',
      '33240444',
      '10242142',
      NULL,
      '21333200',
      '24430434',
      '03432223',
      '44412402',
      NULL,
      '02310212',
      '04203143',
      '23430232',
      '11111433',
      NULL,
      '33033402',
      '34030112',
      '33340212',
      '23140421',
      '23142332',
      '13403423',
      '43440041',
      '40042334',
      '10210331',
      '22213423',
      '11102211',
      NULL,
      '12414434',
      '01332422',
      '40311021',
      '43414232',
      NULL,
      '42031330',
      '12440014',
      '43021014',
      '43404123',
      NULL,
      '22441131',
      NULL,
      '133',
      '31',
      NULL,
      NULL,
      '4324214',
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      ' 0-16-1977',
      ' 0-23-1990',
      NULL,
      NULL,
      11.380088,
      0.785680,
      18,
      9,
      50.020553,
      14.236991,
      19,
      14.329020,
      14.863591,
      15,
      22,
      5.541535,
      7.120141,
      2,
      5,
      3.938215,
      NULL,
      5,
      7.125807,
      6.908504,
      NULL,
      9,
      1,
      35,
      116,
      47.275683,
      124.310198,
      NULL,
      149,
      NULL,
      0,
      33,
      NULL,
      35.834214,
      216,
      128,
      ' 9-15-2000',
      11.347167,
      3.378664,
      1.413174,
      0.933812,
      0.315011,
      0,
      NULL,
      NULL,
      1,
      1.635382,
      NULL,
      NULL,
      0.173072,
      1,
      NULL,
      1.521992,
      0,
      0.145509,
      1,
      3.410110,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1992',
      19.192878,
      NULL,
      NULL,
      19.440095,
      0.650473,
      NULL,
      ' 0- 9-1994',
      NULL,
      NULL,
      63,
      0,
      0.381464,
      82.184544,
      1,
      0,
      31.963013,
      1.964469,
      1.858123,
      173.039121,
      ' 6-15-1987',
      97,
      NULL,
      NULL,
      32.669968,
      NULL,
      8,
      36,
      52.746726,
      NULL,
      15,
      3,
      36,
      '11-17-1985',
      1.380162,
      9.487745,
      16.287136,
      13,
      43,
      NULL,
      NULL,
      ' 0-25-1986',
      18.608857,
      NULL,
      ' 7-25-2001',
      9,
      11.191723,
      14,
      2,
      23.405167,
      6,
      0,
      7,
      1,
      87.462241,
      11,
      0.542284,
      7,
      NULL,
      NULL,
      0,
      0,
      0,
      ' 5-16-1981',
      2.595427,
      0,
      1,
      NULL,
      24.175150,
      4.094992,
      '10-21-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.382312,
      '11-24-2001',
      NULL,
      10.997924,
      NULL,
      0.379046,
      16,
      NULL,
      13,
      10,
      ' 9-29-1987',
      5.448375,
      8,
      ' 1-19-1980',
      2,
      1,
      15.347557,
      ' 5-17-2001',
      0,
      20,
      NULL,
      '10-16-1987',
      1,
      225.718337,
      ' 8-15-1975',
      NULL,
      40,
      NULL,
      NULL,
      ' 8-18-1983',
      NULL,
      1,
      96.561494,
      '11-15-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


