set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9738814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '1',
      '0',
      '1',
      '2',
      '3',
      '1',
      '1',
      '4',
      '3',
      '3',
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      '2',
      '2',
      '2',
      NULL,
      '2',
      NULL,
      '1',
      NULL,
      '4',
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      '',
      '',
      '2',
      '3',
      NULL,
      '4',
      '3',
      '2',
      '1',
      '0',
      '0',
      '1',
      '3',
      '340',
      '12104200',
      37.782757,
      NULL,
      '4211243',
      2,
      0,
      0,
      NULL,
      '432331',
      4,
      ' 7-25-1990',
      ' 6-19-1999',
      124.773959,
      4,
      1.142681,
      17.429938,
      19.971544,
      2.824113,
      NULL,
      4.753902,
      2.429251,
      23,
      8.656226,
      19.011910,
      40,
      21,
      NULL,
      NULL,
      NULL,
      15,
      75.861219,
      10.872207,
      18.531109,
      4,
      NULL,
      21.527428,
      0,
      27.890968,
      114,
      61.988764,
      19,
      74.752973,
      151,
      ' 5- 0-1990',
      20,
      26,
      18,
      19,
      0,
      NULL,
      ' 4-10-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.962915,
      3,
      10.748927,
      19.634022,
      NULL,
      3,
      ' 9-27-2002',
      NULL,
      0,
      88.556107,
      1.738070,
      0.276677,
      34,
      NULL,
      1.204595,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1984',
      4.116965,
      89,
      24.938446,
      111.683690,
      NULL,
      110.690058,
      43.916181,
      29.505062,
      22.511432,
      48,
      113,
      1,
      ' 7- 8-2003',
      15,
      6.064434,
      4,
      1,
      NULL,
      86,
      1.465088,
      ' 1- 2-1981',
      18.473360,
      5,
      ' 6- 6-2001',
      4,
      16,
      29.054902,
      19.889547,
      4.881406,
      6,
      0.088235,
      9,
      NULL,
      133,
      NULL,
      7,
      7.901721,
      9.059860,
      0,
      0.196155,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      ' 9-14-1974',
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      25.987004,
      ' 5-16-1984',
      6,
      8,
      ' 5-28-1992',
      95.626034,
      41.955696,
      ' 6-10-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      15.326389,
      ' 6-23-1999',
      57.969921,
      37.960976,
      NULL,
      NULL,
      0.864240,
      111,
      ' 7-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


