set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9771224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      '0',
      '2',
      '4',
      NULL,
      '3',
      '1',
      '3',
      '1',
      '1',
      '2',
      '0',
      NULL,
      '2',
      NULL,
      NULL,
      '2',
      NULL,
      '2',
      '1',
      NULL,
      '4',
      '',
      '2',
      '',
      '2',
      '3',
      '1',
      '0',
      '2',
      NULL,
      '',
      '1',
      '0',
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      '1',
      '0',
      '4',
      '1',
      '011',
      '42413112',
      84.347488,
      39,
      '2133043',
      2,
      0.693458,
      3,
      1,
      '412304',
      NULL,
      NULL,
      ' 6-15-2000',
      92,
      34.013684,
      30,
      17,
      45,
      12.934487,
      16.201195,
      12,
      18,
      25,
      0.395164,
      6,
      NULL,
      13,
      31,
      10.296190,
      13,
      3,
      51.478305,
      26,
      NULL,
      11,
      86.762158,
      NULL,
      NULL,
      87.537277,
      NULL,
      18,
      40.744265,
      199,
      155.603438,
      ' 5- 9-1984',
      NULL,
      26,
      NULL,
      NULL,
      93,
      NULL,
      ' 7-27-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513781,
      4.725543,
      7.154285,
      9,
      ' 9- 8-1990',
      1,
      1.846213,
      209,
      1.575075,
      1.462090,
      NULL,
      NULL,
      1.619751,
      18,
      NULL,
      NULL,
      NULL,
      ' 2-15-1998',
      NULL,
      77,
      53,
      13,
      6.274508,
      NULL,
      10.389468,
      24.026868,
      31.040689,
      11.384673,
      43,
      4.368622,
      ' 2-13-2002',
      22,
      NULL,
      NULL,
      58,
      63.541869,
      138,
      4.189568,
      '11- 8-1991',
      7.346127,
      NULL,
      ' 1-12-1975',
      5,
      13.363756,
      15.734264,
      11.703399,
      13,
      NULL,
      0.301883,
      14,
      NULL,
      123,
      NULL,
      NULL,
      11.660490,
      8.638635,
      1,
      1,
      NULL,
      0,
      ' 7-16-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      258,
      2.259733,
      ' 8- 6-1977',
      NULL,
      NULL,
      NULL,
      19.065846,
      '10-13-1999',
      30.204801,
      NULL,
      3.810355,
      1,
      NULL,
      140.409884,
      110,
      ' 3-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-29-1974',
      49.464548,
      41,
      47,
      ' 9- 5-1978',
      0.935394,
      91.908048,
      ' 7-26-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


